<?php 
add_action('add_meta_boxes', 'anps_portfolio_content_add_custom_box');
add_action('save_post', 'anps_portfolio_content_save_postdata');
function anps_portfolio_content_add_custom_box() {
    $pages = array('portfolio', 'post');
    foreach($pages as $screen) {
        add_meta_box('anps_portfolio_side_meta', __('Breadcrumbs parent page', ANPS_TEMPLATE_LANG), 'display_portfolio_breadcrumbs_meta_box', $screen, 'side', 'core');
    }
}
function display_portfolio_breadcrumbs_meta_box($post) {
    $custom_breadcrumbs = get_post_meta( $post -> ID, $key = 'custom_breadcrumbs', $single = true );
    ?>
    <select name="custom_breadcrumbs">
            <option value="0">*** Select ***</option>
            <?php 
                    $pages = get_pages();
                    foreach ($pages as $item) :
                            if ($custom_breadcrumbs == $item->ID) {
                                    $selected = 'selected="selected"';
                            }
                            else {         
                                    $selected = '';
                            }
            ?>      <option value="<?php echo $item->ID; ?>" <?php echo $selected; ?>><?php echo $item->post_title; ?></option>                 
            <?php endforeach; ?>            
    </select> 
<?php }
function anps_portfolio_content_save_postdata($post_id) { 
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    if (empty($_POST) || !isset($_POST['post_ID'])) {
        return;
    }
    if(!$_POST['post_ID']) {
        if(!$post_id) {
            return;
        } else {
            $_POST['post_ID'] = $post_id;
        }
    }
    if(!isset($_POST['post_type'])) {
        return;
    }
    // Check permissions
    if ('portfolio' == $_POST['post_type']) { 
        if (!current_user_can('edit_page', $post_id))
            return;
    }
    else {
        if (!current_user_can('edit_post', $post_id))
            return;
    }
    $post_ID = $_POST['post_ID'];
    if (!isset($_POST['custom_breadcrumbs'])) {
        $_POST['custom_breadcrumbs'] = '';
    }
    $custom_breadcrumbs = $_POST['custom_breadcrumbs'];
    add_post_meta($post_ID, 'custom_breadcrumbs', $custom_breadcrumbs, true) or update_post_meta($post_ID, 'custom_breadcrumbs', $custom_breadcrumbs);
}
