<?php
include_once 'classes/Options.php';

$page_data = $options->get_shop_setup_data();
if (isset($_GET['save_shop_setup'])) {
  $options->save_shop_setup();
}
?>
<form action="themes.php?page=theme_options&sub_page=shop_settings&save_shop_setup" method="post">   
    <div class="content-top"><input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>" /><div class="clear"></div></div>
    <div class="content-inner">
        <!-- Page setup -->
        <h3><?php _e("Shop setup:", ANPS_TEMPLATE_LANG); ?></h3>
        <!-- Shop number of columns -->
        <div class="input"> 
            <label for="shop_columns"><?php _e("Number of columns", ANPS_TEMPLATE_LANG); ?></label>
            <?php $pag_type = array('2 columns', '3 columns', '4 columns'); ?>
            <select name="shop_columns">
                <?php
                foreach ($pag_type as $item) :
                    if ($page_data['shop_columns'] == $item) 
                        $selected = 'selected="selected"';
                    else 
                        $selected = '';
                    ?>
                    <option value="<?php echo $item; ?>" <?php echo $selected; ?>><?php echo $item; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <!-- Shop number of products -->
        <div class="input"> <?php if (!isset($page_data['shop_per_page'])) $page_data['shop_per_page'] = ''; ?>
            <label for="shop_per_page"><?php _e("Products per page", ANPS_TEMPLATE_LANG); ?></label>
            <input type="text" name="shop_per_page" value="<?php echo $page_data['shop_per_page']; ?>"/>
        </div>
        <!-- Shop number of related products -->
        <div class="input"> <?php if (!isset($page_data['shop_related_per_page'])) $page_data['shop_related_per_page'] = ''; ?>
            <label for="shop_related_per_page"><?php _e("Number of related products", ANPS_TEMPLATE_LANG); ?></label>
            <input type="text" name="shop_related_per_page" value="<?php echo $page_data['shop_related_per_page']; ?>"/>
        </div>
        <?php 
        if(!isset($page_data['shop_hide_cart']))
            $checked='';
        elseif ($page_data['shop_hide_cart'] == '-1')
            $checked = '';
        elseif ($page_data['shop_hide_cart'] == '')
            $checked = '';
        else
            $checked = 'checked';
        ?>
        <label for="shop_hide_cart"><?php _e("Hide header cart", ANPS_TEMPLATE_LANG); ?></label>
        <input class="small_input" style="margin-left: 74px" type="checkbox" name="shop_hide_cart" <?php echo $checked; ?> />
        <?php 
        if(!isset($page_data['shop_category']))
            $checked='';
        elseif ($page_data['shop_category'] == '-1')
            $checked = '';
        elseif ($page_data['shop_category'] == '')
            $checked = '';
        else
            $checked = 'checked';
        ?>
        <label for="shop_category"><?php _e("Shop show category filter", ANPS_TEMPLATE_LANG); ?></label>
        <input class="small_input" style="margin-left: 74px" type="checkbox" name="shop_category" <?php echo $checked; ?> />
    </div>

    <div class="content-top" style="border-style: solid none; margin-top: 70px">
        <input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>">
        <div class="clear"></div>
    </div>
</form>