<?php
/* Accordion */
$accordion_counter = 0;
$accordion_opened = false;
global $accordion_type;
function anps_accordion_func( $atts,  $content ) {
    extract( shortcode_atts( array(
        "opened" => "false",
        "type" => ""
    ), $atts ) );
    wp_enqueue_script('collapse');
    global $accordion_counter, $accordion_opened, $accordion_type; 
    $accordion_type = $type;
    $accordion_counter++;
    if($opened=="true") {
        $accordion_opened = true;
    }
    return '<div class="panel-group" id="accordion' . $accordion_counter . '">' .  do_shortcode($content) . '</div>';
}
/* END Accordion */
/* Accordion item */
$accordion_item_counter = 0;
function anps_accordion_item_func( $atts,  $content ) { 
    extract( shortcode_atts( array(
            'title' => ''           
    ), $atts ) );
    $opened_class = "";
    global $accordion_item_counter, $accordion_opened, $accordion_counter, $accordion_type; 
    if( $accordion_opened ) {
        $opened_class = " in";
        $closed_class = "";
        $accordion_opened = false;
    } else {
        $closed_class = " class='collapsed'";
    } 
    $data_parent = ' data-parent="#accordion'. $accordion_counter.'"';
    if($accordion_type=="toggle") {
        $data_parent = "";
    }
    $accordion_item_counter++;
    return '<div class="panel">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <a data-toggle="collapse" '.$closed_class.' href="#collapse' . $accordion_item_counter . '"'. $data_parent.'>' . $title . '</a>
                    </h4>
                </div>
                <div id="collapse' . $accordion_item_counter . '" class="panel-collapse collapse'.$opened_class.'">
                    <div class="panel-body">' .  do_shortcode($content) . '</div>
                </div>
            </div>';
}
/* END Accordion item */
/* Alert */
function anps_alert_func($atts, $content) {
    extract( shortcode_atts( array(
        'type' => ''
    ), $atts ) ); 
    wp_enqueue_script('alert');
    switch($type) {
        case "": 
            $type_class = ""; 
            $icon = "bell-o";
            break;
        case "warning": 
            $type_class = " alert-warning";  
            $icon = "exclamation";
            break;
        case "info": 
            $type_class = " alert-info";  
            $icon = "info";
            break;
        case "success": 
            $type_class = " alert-success";
            $icon = "check";
            break;
        case "useful": 
            $type_class = " alert-useful";  
            $icon = "lightbulb-o";
            break;
        case "normal": 
            $type_class = " alert-normal";  
            $icon = "hand-o-right";
            break;
    }
    return '<div class="alert'.$type_class.'">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
		<i class="fa fa-'.$icon.'"></i> '.$content.'
            </div>';
}
/* END Alert */
/* Button */
global $button_counter; 
$button_counter = 0;
function anps_button_func( $atts,  $content ) { 
    extract( shortcode_atts( array(
        'link'       => '',
        'target'     => '_self',
        'size'       => 'small',
        'style_button'      => '',
        'color'      => '',
        'background' => ''
    ), $atts ) );
    global $button_counter;
    
    $style_attr = "";
    if($color && $color!="#ffffff") {
        $style_attr .= "color: " . $color . ";";
    }
    if($background) {
        $style_attr .= "background-color: " . $background . ";";
        if( $style_button == 'style-2' ) {
            $style_attr .= "border-color: " . $background . ";";
        }
    }
    if ( $target != '' ) {
        $target = ' target="' . $target . '"';
    }
    
    switch($size) {
        case "large": $size = "btn-lg"; break;
        case "medium": $size = "btn-md"; break;
        case "small": $size = "btn-sm"; break;
    }

    $style_id = "custom-id-".$button_counter; 
    $button_counter++;
    $style_css='';
    if( !$link ) {
        $style_css .= '<button' . $target . ' class="btn ' . $size . ' ' . $style_button . '" id="'.$style_id.'" style="'.$style_attr.'">' .$content . '</button>';
    } else {
        $style_css .= '<a' . $target . ' href="' . $link . '" class="btn ' . $size . ' ' . $style_button . '" id="'.$style_id.'" style="'.$style_attr.'">' .$content. '</a>';
    }  
    return $style_css;
}
/* END Button */
/* Columns */
function anps_content_half_func( $atts,  $content ) {
	extract( shortcode_atts( array(
            'id' => '',
            'class' => ''
	), $atts ) );
    $content = do_shortcode( shortcode_unautop( $content ) );
    if ( '</p>' == substr( $content, 0, 4 )
    and '<p>' == substr( $content, strlen( $content ) - 3 ) )
    $content = substr( $content, 4, strlen( $content ) - 7 );
    
    if ( $id == "first" ) {
        return '<div class="row">
                <div class="col-md-6 ' . $class . '">' . $content . '</div>';
    }
    elseif ( $id == "last" ) {
        return '<div class="col-md-6 ' . $class . '">' . $content . '</div>
                </div>';
    }
    else {
        return '<div class="col-md-6 ' . $class . '">' . $content . '</div>';
    }
}
function anps_content_third_func( $atts,  $content ) {
	extract( shortcode_atts( array(
		'id' => '',
        'class' => ''
	), $atts ) );
    $content = do_shortcode( shortcode_unautop( $content ) );
    if ( '</p>' == substr( $content, 0, 4 )
    and '<p>' == substr( $content, strlen( $content ) - 3 ) )
    $content = substr( $content, 4, strlen( $content ) - 7 );
    if ( $id == "first" ) {
        return '<div class="row">
                <div class="col-sm-4 ' . $class . '">' . $content . '</div>';
    }
    elseif ( $id == "last" ) {
        return '<div class="col-sm-4 ' . $class . '">' . $content . '</div>
                </div>';
    }
    else {
        return '<div class="col-sm-4 ' . $class . '">' . $content . '</div>';
    }
}
function anps_content_two_third_func( $atts,  $content ) {
	extract( shortcode_atts( array(
		'id' => '',
        'class' => ''
	), $atts ) );
    $content = do_shortcode( shortcode_unautop( $content ) );
    if ( '</p>' == substr( $content, 0, 4 )
    and '<p>' == substr( $content, strlen( $content ) - 3 ) )
    $content = substr( $content, 4, strlen( $content ) - 7 );
    if ( $id == "first" ) {
        return '<div class="row">
                <div class="col-sm-8 ' . $class . '">' . $content . '</div>';
    }
    elseif ( $id == "last" ) {
        return '<div class="col-sm-8 ' . $class . '">' . $content . '</div>
                </div>';
    }
    else {
        return '<div class="col-sm-8 ' . $class . '">' . $content . '</div>';
    }
}
function anps_content_quarter_func( $atts,  $content ) {
	extract( shortcode_atts( array(
		'id' => '',
        'class' => ''
	), $atts ) );
    $content = do_shortcode( shortcode_unautop( $content ) );
    if ( '</p>' == substr( $content, 0, 4 )
    and '<p>' == substr( $content, strlen( $content ) - 3 ) )
    $content = substr( $content, 4, strlen( $content ) - 7 );
    if ( $id == "first" ) {
        return '<div class="row">
                <div class="col-md-3 ' . $class . '">' . $content . '</div>';
    }
    elseif ( $id == "last" ) {
        return '<div class="col-md-3 ' . $class . '">' . $content . '</div>
                </div>';
    }
    else {
        return '<div class="col-md-3 ' . $class . '">' . $content . '</div>';
    }
}
function anps_content_two_quarter_func( $atts,  $content ) {
	extract( shortcode_atts( array(
		'id' => '',
        'class' => ''
	), $atts ) );
    $content = do_shortcode( shortcode_unautop( $content ) );
    if ( '</p>' == substr( $content, 0, 4 )
    and '<p>' == substr( $content, strlen( $content ) - 3 ) )
    $content = substr( $content, 4, strlen( $content ) - 7 );
    if ( $id == "first" ) {
        return '<div class="row">
                <div class="col-md-6 ' . $class . '">' . $content . '</div>';
    }
    elseif ( $id == "last" ) {
        return '<div class="col-md-6 ' . $class . '">' . $content . '</div>
                </div>';
    }
    else {
        return '<div class="col-md-6 ' . $class . '">' . $content . '</div>';
    }
}
function anps_content_three_quarter_func( $atts,  $content ) {
	extract( shortcode_atts( array(
		'id' => '',
        'class' => ''
	), $atts ) );
    $content = do_shortcode( shortcode_unautop( $content ) );
    if ( '</p>' == substr( $content, 0, 4 )
    and '<p>' == substr( $content, strlen( $content ) - 3 ) )
    $content = substr( $content, 4, strlen( $content ) - 7 );
    if ( $id == "first" ) {
        return '<div class="row">
                <div class="col-md-9 ' . $class . '">' . $content . '</div>';
    }
    elseif ( $id == "last" ) {
        return '<div class="col-md-9 ' . $class . '">' . $content . '</div>
                </div>';
    }
    else {
        return '<div class="col-md-9 ' . $class . '">' . $content . '</div>';
    }
}
/* END Columns */
/* Coming soon */
function anps_coming_soon_func($atts, $content) {
    extract( shortcode_atts( array(
        'image_u' => "",
        'image' => "",
        'text'=>"",
        'date' => "2014/10/15"
    ), $atts ) );

    $img_bg = '';
    
    if($image_u) {
        $image = wp_get_attachment_image_src($image_u, 'full');
        $image = $image[0];
    }
    if($image) {
        $img_bg = " style='background-image: url(".$image.");'";
    }
    return '</div></div></section><div class="coming-soon site-wrapper text-center"'.$img_bg.'>
                <div class="coming-soon-content">'.
                    do_shortcode($content)
                    .'<h2 class="primary">'.$text.'</h2>
                    <ul class="countdown"></ul>
                </div>
            </div>
	<script src="'.get_template_directory_uri()  . "/js/countdown.js".'"></script>
        <script>
		jQuery(".countdown").countdown("'.$date.'", function(event) {
		     jQuery(this).html(event.strftime("<li><span>%D</span><label>days</label></li><li><span>%H</span><label>hours</label></li><li><span>%M</span> <label>minutes</label></li><li><span>%S</span><label>seconds</label></li>"));
		});
	</script>';
}
/* END Coming soon */
/* Contact shortcode */
function anps_contact_func($atts, $content) { 
    extract( shortcode_atts( array(
        'success_msg' => 'Message sucessfuly sent!',
        'error_text' => 'Please insert only letters',
        'error_number' => 'Please insert numbers only',
        'error_email' => 'Please insert a valid email',
        'error_phone' => 'Please insert a valid phone number',
        'error_required' => 'This element is required',
        'email_from' => 'support@anspthemes.com',
        'subject' =>'This is an awesome email!'
    ), $atts ) );
    $anps_contact_data = "<form class='contact-form' role='form' method='post' data-form='contact' data-subject='".$subject."' data-from='".$email_from."' data-required='".$error_required."' data-email='".$error_email."' data-number='".$error_number."' data-text='".$error_text."' data-success='" . $success_msg . "'>";
    $anps_contact_data .= do_shortcode($content);
    $anps_contact_data .= "</form>";
    return $anps_contact_data; 
}
/* END Contact */
/* Contact item */
function anps_contact_item_func($atts, $content) {
    extract( shortcode_atts( array(
        'type' => 'text',
        'rows' => '5',
        'required' => 'false',
        'placeholder' => '',
        'validation' => 'none'
    ), $atts ) );
    
    if($required=="true") {
        $required_data = ' data-required="required"';
    } else {
        $required_data = "";
    }
    if($type=="text") {
        $input_type = '<div class="form-group">';
        $input_type .= '<input type="text" placeholder="'.$placeholder.'" name="'.$placeholder.'" data-validation="'.$validation.'"'.$required_data.'>';
        $input_type .= '</div>';
    } elseif ($type=="textarea") {
        $input_type = '<div class="form-group">';
        $input_type .= '<textarea rows="'.$rows.'" placeholder="'.$placeholder.'" name="'.$placeholder.'" data-validation="'.$validation.'"'.$required_data.'></textarea>';
        $input_type .= '</div>';       
    } elseif($type=="captcha") {
        global $anps_contact_data;
        $publickey = $anps_contact_data['public_key']; 
        $input_type = "<div class='captcha'>" . recaptcha_get_html($publickey) . "</div>";
        $input_type .= '<div class="clear"></div>';        
    }
    return $input_type;
}
/* END Contact item */
/* Contact button */
function anps_contact_button_func($atts, $content) { 
    return "<button type='submit' class='btn btn-md'>".__("Submit", ANPS_TEMPLATE_LANG)."</button>";
}
/* END Contact button */
/* Contact info */
function anps_contact_info_func( $atts,  $content ) { 
    return "<ul class='contact-info'>".do_shortcode($content)."</ul>";
}
/* END Contact info */
/* Contact info item */
function anps_contact_info_item_func( $atts,  $content ) {  
    extract( shortcode_atts( array(
        'icon' => ''
    ), $atts ) ); 
    return "<li><i class='fa fa-".$icon."'></i>".$content."</li>";
}
/* END Contact info item */
/* Dropcaps */
function anps_dropcaps_func($atts, $content) {
    extract( shortcode_atts( array(
                'style' => ''
        ), $atts ) );
    $style_class = "";
    if($style) {
        $style_class = " style-2";
    }
    return '<p class="dropcaps'.$style_class.'">'.do_shortcode($content).'</p>';
}
/* END Dropcaps */
/* Error 404 */
function anps_error_404_func( $atts,  $content ) {
	extract( shortcode_atts( array(
            'title' => '',
            'title_large' => '',
            'sub_title' => ''
        ), $atts ) );
        $text = "";
        $text .= "</div></div></section>";
        $text .= "<section class='style-2'><div class='container'><div class='row'><div class='col-md-12'>";
        $text .= "<div class='error-404 text-center'>";
        $text .= "<h1>";
        if($title) {
            $text .= $title;
        }
        if($title_large) {
            $text .= "<em class='color'>$title_large</em>";
        }
        $text .= "</h1>";
        $text .= "<h2>$sub_title</h2>";
        $text .= '<a href="javascript:javascript:history.go(-1)" class="btn btn-lg">'.$content.'</a>';
        $text .= '</div></div></div></section>';
	return $text;
}
/* END Error 404 */
/* Google maps */
$google_maps_counter = 0;
function anps_google_maps_func( $atts,  $content ) {
    global $google_maps_counter;
    $google_maps_counter++;
    extract( shortcode_atts( array(
        'zoom'   => '14',
        'fullwidth' => "",
        'scrollwheel' => '',
        'draggable' => ''
    ), $atts ) ); 
    wp_enqueue_script('gmap3_link');
    wp_enqueue_script('gmap3');
    global $anps_options_data;
    $maps_return = "";
    $maps_return .= "<script>
            jQuery(document).ready(function( $ ) { 
                map('#map$google_maps_counter', '$content', $zoom, '$scrollwheel', '$draggable');  
            });
            </script>";
    $maps_return .= "<section class='map' id='map$google_maps_counter'></section>";
    return $maps_return;
}
/* END Google maps */
/* Heading */
function anps_heading_func( $atts,  $content ) {  
    extract( shortcode_atts( array(
        'size' => '2',
        'heading_class' => "",
        'h_id' => "",
        'icon_type' => "svg1",
        'icon' => "",
        'img' => "",
        'img_u' => ""
    ), $atts ) ); 
    $id = ''; 
    if($h_id) {
        $id = " id='".$h_id."'";
    }
    $svg = "";
    switch($heading_class) {
        case "" : $head_class = ""; break;
        case "style-2" : $head_class = " class='style-2'"; break;
        case "icon" : 
            $head_class=" class='section-heading text-center'"; 
            if($icon_type=="svg1") {
                $svg = '<svg class="mini-logo" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="126px" height="112px" viewBox="0 0 126 112" enable-background="new 0 0 126 112" xml:space="preserve"><g><g><g><path d="M63.016,1.134C55.414,6.166,53.994,17.37,53,29c5.021,1.321,9.101,3.579,10.016,8.998 C63.93,32.579,68.01,30.321,73.031,29C72.037,17.37,70.617,6.166,63.016,1.134z"></path></g></g></g><g><g><g><path d="M63.125,49.996C61.076,24.065,20.794,22.264,1,34c0,0.667,0.167,0.25,0.167,0.917C7.297,55.219,27.661,71.48,55.109,64 c-6.523,7.979,3.71,30.104-5.01,40c3.785,3.008,10.959,1.13,13.026-2.999c2.068,4.129,9.242,6.007,13.027,2.999 c-8.721-9.896,1.512-32.021-5.011-40c27.448,7.48,47.813-8.781,53.942-29.083c0-0.667,0.167-0.25,0.167-0.917 C105.457,22.264,65.175,24.065,63.125,49.996z"></path></g></g></g><g><g><g><path d="M50,70c-25.705-1.039-29.236,20.098-34,40C31.967,101.301,53.156,97.822,50,70z"></path></g></g></g><g><g><g><path d="M76.297,70c25.705-1.039,29.236,20.098,34,40C94.33,101.301,73.141,97.822,76.297,70z"></path></g></g></g></svg>';
            } elseif($icon_type=="svg2") {
                $svg = '<svg class="mini-logo-2" version="1.1" id="Layer_1_xA0_Image_1_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 126 112" enable-background="new 0 0 126 112" xml:space="preserve"><polygon points="61,8.714 76.072,39.254 109.775,44.152 85.389,67.924 91.145,101.491 61,85.643 30.854,101.491 36.612,67.924 12.224,44.152 45.927,39.254 "/></svg>';
            } elseif($icon_type=="svg3") {
                $svg = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 500 500" enable-background="new 0 0 500 500" xml:space="preserve" class="mini-logo-3"><path d="M424.973,31.913c-49.298,22.189-118.545,63.499-181.625,137.295C129.331,302.599,82.678,474.479,82.678,474.479 s28.408-139.59,114.075-289.206C247.786,96.148,328.097,39.948,384.699,9.069C309.041-13.336,195.891,41.488,111.752,147.42 C13.654,270.929-7.853,417.135,63.717,473.979c71.569,56.845,209.112,2.803,307.211-120.704 C466.167,233.361,489.207,92.063,424.973,31.913z"></path></svg>';
            } elseif($icon_type=="icon") {
                $svg = "<i class='mini-logo-icon fa fa-".$icon."'></i>";
            } elseif($icon_type=="image") {
                if($img_u) {
                    $img = wp_get_attachment_image_src($img_u, 'full');
                    $img = $img[0];
                }
                $svg = "<img class='mini-logo' src='".$img."' />";
            }
            break;
    }

    return $svg.'<h'.$size.$head_class.' '.$id.'><span>' . $content . '</span></h'.$size.'>';
}
/* END Heading */
/* Icon shortcode */
function anps_icon_func( $atts,  $content ) {
	extract( shortcode_atts( array(
            'url' => '',
            'target' => '_self',
            'icon' => '',
            'title' => '',
            'subtitle' => ''
        ), $atts ) );
    
    if($url) {
        return '<div class="icon">
                    <header>
                        <a href="'.$url.'" target="'.$target.'"><div class="fa fa-'.$icon.'"></div></a>
                        <h2>'.$title.'</h2>    
                    </header>
                    <span>'.$subtitle.'</span>    
                    <p>'.$content.'</p>
                </div>';          
    } else {
        return '<div class="icon">
                    <header>
                        <div class="fa fa-'.$icon.'"></div>
                        <h2>'.$title.'</h2>    
                    </header>
                    <span>'.$subtitle.'</span>    
                    <p>'.$content.'</p>
                </div>';          
    }
  	
}
/* END Icon */
/* Image */
function anps_image_func($atts, $content) {
    extract( shortcode_atts( array(
        'alt' => '',
        'url' => '',
        'target' => '_blank'
    ), $atts ) );

    $url = str_replace("&quot;", "", $url);
    $alt = str_replace("&quot;", "", $alt);
    $target = str_replace("&quot;", "", $target);    
    $img_data = "";
    if($url) {
        $img_data .= "<a href='".$url."' target='".$target."'>";
    }
    $img_data .= "<img alt='" . $alt . "' src='".$content."' />";
    if($url) {
        $img_data .= "</a>";
    }
    return $img_data;
}
/* END Image */
/* List */
function anps_list_func($atts, $content) {
    extract( shortcode_atts( array(
        'class' => ''
    ), $atts ) ); 
    if( $class == "anps_arrow" ) {
        $class = "arrow";
    }
    return "<ul class='list ".$class."'>".do_shortcode($content)."</ul>";
}
/* END List */
/* List item */
function anps_list_item_func($atts, $content) {
    extract( shortcode_atts( array(
        'icon' => ''
    ), $atts ) ); 
    $return = "<li>";
    if($icon) {
        $return .= "<i class='fa fa-".$icon."'></i>";
    }
    $return .= $content;
    $return .= "</li>";
    return $return;
}
/* END List item */
/* Mark */
function anps_mark_func( $atts,  $content ) {
    extract( shortcode_atts( array( 
            'style' => ''
        ), $atts ) );
    if( $style && $style != "" ) {
        return '<mark class="style-2">' . do_shortcode($content) . '</mark>';
    } else {
        return '<mark>' . do_shortcode($content) . '</mark>';
    }
}
/* END Mark */
/* Opening time */
function anps_opening_time_func( $atts,  $content ) {
    extract( shortcode_atts( array( 
            'title' => 'we are opened'
        ), $atts ) );

if (is_plugin_active( 'js_composer/js_composer.php' ) && get_option('anps_vc_legacy', "0")=="on") {

    $data = '</div></div></section><section class="opening-hours"><div class="container no-margin"><div class="row"><div class="col-md-12"><ul>';
    $data .= "<li><h5 class='color'>$title</h5></li>";
    $data .= do_shortcode($content);
    $data .= '</ul></div></div></div></section><section class="container"><div class="row"><div class="col-md-12">';
    return $data;

} else {
    $data = '<section class="opening-hours"><div class="container no-margin"><div class="row"><div class="col-md-12"><ul>';
    $data .= "<li><h5 class='color'>$title</h5></li>";
    $data .= do_shortcode($content);
    $data .= '</ul></div></div></div></section>';
    return $data;
}
 


}
/* END Opening time */
/* Opening time item */
function anps_opening_time_item_func( $atts,  $content ) {
    extract( shortcode_atts( array( 
            'day' => 'mon',
            'from' => '9',
            'to' => '22'
        ), $atts ) );
    return "<li><h6>$day</h6> $from - $to</li>";
}
/* END Opening time item */
/* Portfolio */
function anps_portfolio_func($atts, $content) {
    extract( shortcode_atts( array(
        'filter' => 'on',
    	'columns' => '4',
        'category'=> '',
        'orderby' => '',
    	'order' => '',
        'per_page' => -1
	), $atts ) );

    // Get the number of all posts in all individual categories
    $cats = get_terms('portfolio_category', 'orderby=none&hide_empty');
    $individual_cat_posts = '';
    foreach ($cats as $cat) {
        $tax_query = array(
            array(
                'taxonomy' => 'portfolio_category',
                'field' => 'id',
                'terms' => $cat->term_id
            )
        );

        $args = array(
            'post_type' => 'portfolio',
            'orderby' => $orderby,
            'order' => $order,
            'showposts' => $per_page,
            'tax_query' => $tax_query
        );

        $posts = new WP_Query( $args );
        if( $individual_cat_posts != '' ) {
            $individual_cat_posts .= ':';
        }
        $individual_cat_posts .= $posts->found_posts;
    }

    $tax_query='';
    if($category && $category!='All') {
        $tax_query = array(
            array(
                'taxonomy' => 'portfolio_category',
                'field' => 'id',
                'terms' => $category
            )
       );
    }

    $args = array(
        'post_type' => 'portfolio',
        'orderby' => $orderby,
        'order' => $order,
        'showposts' => $per_page,
        'tax_query' => $tax_query
    );
    $portfolio_posts = new WP_Query( $args );
    
    $portfolio_data = "";
    if($filter=="on") {
        $portfolio_data .= "<ul class='filter text-center'>";
        $portfolio_data .= "<li><button class='selected' data-filter='*'>".__("all", ANPS_TEMPLATE_LANG)."</button></li>";
        $filters = get_terms('portfolio_category', 'orderby=none&hide_empty');
        foreach ($filters as $item) {
            $portfolio_data .= '<li><button class="" data-filter="' . strtolower(str_replace(" ", "-", $item->name)) . '">' . $item->name . '</button></li>';
        }
        $portfolio_data .= "</ul>";
    } 
    $portfolio_data .= '<div class="posts portfolio" data-perpage="' . $per_page . '" data-order="' . $order . '" data-orderby="' . $orderby . '" data-individual-categories="' . $portfolio_posts->found_posts . ':' . $individual_cat_posts . '">';
    while($portfolio_posts->have_posts()) : 
        $portfolio_posts->the_post(); 
        $portfolio_cat = ""; 
        if (get_the_terms(get_the_ID(), 'portfolio_category')) {
            $first_item = false;
            foreach (get_the_terms(get_the_ID(), 'portfolio_category') as $cat) {
                if($first_item) {
                    $portfolio_cat .= " ";
                }
                $first_item = true;
                $portfolio_cat .= strtolower(str_replace(" ", "-", $cat->name));
            }
        }
        $image_class = "portfolio-thumb";
        if(has_post_thumbnail(get_the_ID())) {
                $image = get_the_post_thumbnail(get_the_ID(), $image_class);
        }
        elseif(get_post_meta(get_the_ID(), $key ='gallery_images', $single = true )) { 
            $exploded_images = explode(',',get_post_meta(get_the_ID(), $key ='gallery_images', $single = true ));
            $image_url = wp_get_attachment_image_src($exploded_images[0], $image_class); 
            $image = "<img src='".$image_url[0]."' />";
        }
        $portfolio_data .= "<article class='col-md-4 col-sm-6 $portfolio_cat page-1'>";
        $portfolio_data .= "<a href='".get_permalink()."'>".$image;
        $portfolio_data .= "<div class='hover'><i class='fa fa-cutlery'></i>";
        $portfolio_data .= "<h2>".get_the_title()."</h2>";
        $portfolio_data .= "</div></a>";
        $portfolio_data .= "</article>";
    endwhile;
    wp_reset_postdata();
    $portfolio_data .= "</div>";
    $portfolio_data .= '<ul class="page-numbers portfolio-pagination">';
    for($i=1; $i<=ceil($portfolio_posts->found_posts/$per_page); $i++) {
        if( $i == 1 ) {
            $portfolio_data .= '<li class="active"><button class="page-numbers">1</button></li>';
        } else {
            $portfolio_data .= '<li><button class="page-numbers">' . $i . '</button></li>';
        }  
    }
    $portfolio_data .= '</ul>';
    return $portfolio_data;
}
/* END Portfolio */
/* Pricing tables */
function anps_pricing_table_func( $atts,  $content ) {
    extract( shortcode_atts( array(
            'title' => '',
            'currency' => '&euro;',
            'price' => '0',
            'period' => '',
            'button_text' => '',
            'button_url' => '',
            'featured' => ''
        ), $atts ) );
        
        $featured_class="";
        if($featured) {
            $featured_class = " style-2";
        }

        $pricing_data = "<div class='pricing-table".$featured_class."'>";
        $pricing_data .= "<header>";
        $pricing_data .= "<h2>".$title."</h2>";
        $pricing_data .= "<span class='currency'>".$currency."</span><span class='price'>".$price."</span>";
        if($period) {
            $pricing_data .= "<div class='date'>".$period."</div>";
        }
        $pricing_data .= "</header>";
        $pricing_data .= "<ul>".do_shortcode($content)."</ul>";
        if($button_text != '') {
            $pricing_data .= "<footer>";
            $pricing_data .= '<a class="btn btn-md" href="' . $button_url . '">' . $button_text . '</a>';
            $pricing_data .= "</footer>";
        }
        $pricing_data .= "</div>";
        return $pricing_data;
}
/* END Pricing tables */
/* Pricing item */
function anps_pricing_table_item_func( $atts,  $content ) { 
    extract( shortcode_atts( array(), $atts ) );
    return '<li>'.$content ."</li>";
}
/* END Pricing item */
/* Recent blog */
function anps_recent_blog_func($atts, $content) {
    extract( shortcode_atts( array(
		'number' => '3'
	), $atts ) );

     $args = array(
	'posts_per_page'   => $number,
	'orderby'          => "date",
	'order'            => "DESC",
	'post_type'        => 'post',
	'post_status'      => 'publish');
     $posts = new WP_Query( $args );
     $recent_post_text ="";
     if($posts->have_posts()) :
        $recent_post_text .= '<div class="posts blog">';
        while($posts->have_posts()) : 
            $posts->the_post();  
            global $more;
            $more = 0;
            $recent_post_text .= "<article class='col-md-4 col-sm-6'>";
            $recent_post_text .= "<a href='".get_permalink()."'>".get_the_post_thumbnail(get_the_ID(), 'post-thumb');
            $recent_post_text .= "<div class='hover'><i class='fa fa-cutlery'></i></div></a>";
            $recent_post_text .= "<a href='".get_permalink()."'><h2>".get_the_title()."</h2></a>";
            $recent_post_text .= "<p>".strip_tags(apply_filters('the_excerpt', get_the_excerpt()))."</p>";
            $recent_post_text .= "</article>";
        endwhile;
        $recent_post_text .= "</div>";
     endif;
     wp_reset_postdata();
     return $recent_post_text;
}
/* END Recent blog */
/* Recent portfolio */
function anps_recent_portfolio_func($atts, $content) {
    extract( shortcode_atts( array(
        'numberposts' => '6',
        'category'=> '',
        'orderby' => 'post_date',
        'order' => 'DESC',
        'ajax' => false
    ), $atts ) ); 
    $tax_query='';
    if($category && $category!='All') {
        $tax_query = array(
            array(
                'taxonomy' => 'portfolio_category',
                'field' => 'id',
                'terms' => $category
            )
       );
    }
        
    $args = array(
        'post_type' => 'portfolio',
        'orderby' => $orderby,
        'order' => $order,
        'showposts' => $numberposts,
        'tax_query' => $tax_query
    );
    $portfolio_posts = new WP_Query( $args ); 
    
    $portfolio_data = "";
    $portfolio_data .= "<div class='posts anpsportfolioposts'>";
    while($portfolio_posts->have_posts()) : 
        $portfolio_posts->the_post(); 
    
        if(has_post_thumbnail(get_the_ID())) {
            $image = get_the_post_thumbnail(get_the_ID(), 'portfolio-thumb');
        }
        elseif(get_post_meta(get_the_ID(), $key ='gallery_images', $single = true )) { 
            $exploded_images = explode(',',get_post_meta(get_the_ID(), $key ='gallery_images', $single = true ));
            $image_url = wp_get_attachment_image_src($exploded_images[0], 'full', 'sizes=(min-width: 992px) 300px, (min-width: 600px) 350px, 100vw'); 
            $image = "<img src='".$image_url[0]."' />";
        }
        $link = get_permalink();
        if( isset($ajax) && $ajax == "true" ) {
            $link = get_template_directory_uri() . "/single-portfolio.php?ajax=true&amp;id=" . get_the_ID() . "' data-rel='prettyPhoto";
        }
        $portfolio_data .= "<article class='col-md-4 col-sm-6'><a href='" . $link . "'>";
        $portfolio_data .= $image;
        $portfolio_data .= "<div class='hover'><i class='fa fa-cutlery'></i>";
        $portfolio_data .= "<h2>".get_the_title()."</h2>";
        $portfolio_data .= "</div></a>";
        $portfolio_data .= "</article>";
    endwhile;   
    $portfolio_data .= "</div>";
    wp_reset_postdata();
    return $portfolio_data;
}
/* END Recent portfolio */
/* Section */
function section_func($atts, $content) {
    return "<div class='container'>
                <div class='row'>
                    <div class='col-md-12'>".
                        do_shortcode($content)."
                    </div>
                </div>
            </div>";
}
/* END Section */
/* Statement */
function anps_statement_func( $atts,  $content ) {
    extract( shortcode_atts( array( 
        'parallax' => 'false',
        'parallax_overlay' => 'false',
        'image' => '',
        'color' => '',
        'slug' => '',
        'image_u' => ''
    ), $atts ) );
    if($image_u) {
        $image = wp_get_attachment_image_src($image_u, 'full');
        $image = $image[0];
    }
    global $anps_parallax_slug;
    $parallax_class = "";
    $parallax_id = "";
    if($parallax=="true") {
        $parallax_class = " parallax";
        $anps_parallax_slug[] = $slug;
        $parallax_id = "id='$slug'";
    } 
    $parallax_overlay_class = "";
    if($parallax_overlay=="true") {
        $parallax_overlay_class = " parallax-overlay";
    } 
    $containe_class = "";
    $container_before = "";
    $container_after = "";
    $container_class='';
    $style = '';
    if($image) {
        $style = "background-image: url('$image');";
    } elseif($color) {
        $style = "background-color: $color;";
    }
    return '<section '.$parallax_id.' class="jumbotron text-center'.$parallax_class.$parallax_overlay_class.'" style="'.$style.'">'.$container_before.do_shortcode($content).$container_after.'</section>';
}
/* END Statement */
/* Quote */
function anps_quote_func( $atts,  $content ) {
    return '<blockquote>' . $content . '</blockquote>';
}
/* END Quote */
/* Tabs */
global $tabs_counter, $indiv_tab_counter;
$tabs_counter = 0;
$indiv_tab_counter = 0;
function anps_tabs_func( $atts,  $content ) {
    extract( shortcode_atts( array(
        'type' => ''
    ), $atts ) );
    wp_enqueue_script('tab');
    global $tabs_counter, $indiv_tab_counter, $tabs_single;
    $tabs_counter++;
    $sub_tabs_counter = 1;
    $indiv_tab_counter = 0;
    $tabs_single = 0;
    /* Everything inside [tab] shortcode */ 
    preg_match_all( '#\[tab(.*?)\]#', $content, $matches); 
    if ( isset($matches[1]) ) { $tab_titles = $matches[1]; } 
    $class = " style-2";
    $class_before = "";
    $class_after = "";
    $class_content = "";
    if($type == 'vertical') {
        $class = '';
        $class_before = "<div class='col-md-offset-1 col-md-2 vertical'>";
        $class_after = "</div>";
        $class_content = " col-md-7";
    }
    $tabs_menu = '';
    $tabs_menu .= $class_before;
    $tabs_menu .= '<ul class="nav nav-tabs'.$class.'" id="tab-' . $tabs_counter . '">';
    $i=0;
    foreach ( $tab_titles as $tab ) { 
        preg_match_all( '/title="(.*?)\"/', $tab, $title_match); 
        preg_match_all( '/icon="(.*?)\"/', $tab, $icon_match); 
        if(isset($icon_match[1][0])) {
            $icon[$i] = " <i class='fa fa-".$icon_match[1][0]."'></i>";
        } else {
            $icon[$i] = "";
        } 
        if( $sub_tabs_counter == 1 ) {
            $tabs_menu .= '<li class="active"><a data-toggle="tab" href="#tab' . $tabs_counter . '-' . $sub_tabs_counter . '">' . $title_match[1][0].$icon[$i] . '</a></li>';
        } else {
            $tabs_menu .= '<li><a data-toggle="tab" href="#tab' . $tabs_counter . '-' . $sub_tabs_counter . '">' . $title_match[1][0].$icon[$i] . '</a></li>';
        }
        $i++;
        $sub_tabs_counter++; 
    }
    $tabs_menu .= '</ul>';
    $tabs_menu .= $class_after;
    return $tabs_menu . '<div class="tab-content'.$class_content.'">' . do_shortcode($content) . '</div>';
}
/* END Tabs */
/* Tab item */
function anps_tab_func( $atts,  $content ) {
    extract( shortcode_atts( array(
        "title" => ""
    ), $atts ) );
    global $tabs_counter, $tabs_single;
    $active = "";
    if( $tabs_single == 0 ) {
        $active = " active";
    }
    $content = str_replace('&nbsp;', '<p class="blank-line clearfix"><br /></p>', $content);
    $tabs_single++;
    return '<div id="tab' . $tabs_counter . '-' . $tabs_single . '" class="tab-pane' . $active . '">' . do_shortcode( $content ) . '</div>';
}
/* END Tab item */
/* Testimonials */
$testimonials_counter = 0;
global $testimonial_individual;
function anps_testimonials($atts,  $content) { 
    global $testimonials_counter, $testimonial_individual;
    $testimonial_individual = 0;
    $testimonials_counter++;
    $testimonials_number = substr_count($content, "[testimonial");
    $data_return = "";
    $data_return .= '<div id="testimonials'.$testimonials_counter.'" data-ride="testimonials" class="carousel slide testimonials">';
    $data_return .= '<div class="carousel-inner">'.do_shortcode($content).'</div>';
    if($testimonials_number>"1") {
        $data_return .= '<ol class="carousel-indicators">';
        for($i=0;$i<$testimonials_number;$i++) {
            $class = "";
            if($i=="0") {
                $class = ' class="active"';
            }
            $data_return .= '<li data-target="#testimonials'.$testimonials_counter.'" data-slide-to="'.$i.'"'.$class.'></li>';
        }
        $data_return .= '</ol>';
    }
    $data_return .= "</div>";
    return $data_return;
}
/* END Testimonials */
/* Testimonial item */
$testimonial_counter = 0;
function anps_testimonial($atts,  $content) {
    extract( shortcode_atts( array(
        "user" => "",
        "title" => ""
    ), $atts ) ); 
    global $testimonial_counter, $testimonial_individual;
    $testimonial_individual++;
    $testimonial_counter++;
    $class = "";
    if($testimonial_individual=="1") {
        $class = " active";
    }
    $data = "";
    $data .= '<div class="item'.$class.'">';
    $data .= $content;
    $data .= "<h5>".$user."</h5>";
    $data .= "<h6 class='style-2'>".$title."</h6>";
    $data .= "</div>";
    return $data;
}
/* END Testimonial item */
/* Twitter */
global $anps_parallax_slug;
$anps_parallax_slug = array();
function anps_twitter_func($atts, $content) {
    extract( shortcode_atts( array(
		'title' => 'twitter feeds',
                'parallax' => 'false',
                'parallax_overlay' => '',
                'image' => '',
                'color' => '',
                'slug' => '',
                'image_u' => ''
	), $atts ) );
    if($image_u) {
        $image = wp_get_attachment_image_src($image_u, 'full');
        $image = $image[0];
    }
    global $anps_parallax_slug; 
    $parallax_class = "";
    $parallax_id = "";
    if($parallax=="true") {
        $parallax_class = " parallax";
        $parallax_id = " id='$slug'";
        $anps_parallax_slug[] = $slug;
    } 
    
    $parallax_overlay_class = "";
    if($parallax_overlay=="true") {
        $parallax_overlay_class = " parallax-overlay";
    } 
    
    $style = '';
    if($image) {
        $style = "background-image: url('$image');";
    } elseif($color) {
        $style = "background-color: $color;";
    }
    
    load_template(TEMPLATEPATH.'/includes/TwitterAPIExchange.php');
    $settings = array(
        'oauth_access_token' => "1485322933-oo8YU1ZTz5E4Zt92hTTbCdJoZxIJIabghjnsPkX",
        'oauth_access_token_secret' => "RfXHN2OXMkBYp3IaEqrBmPhUYR2N61P8pyHf8QXqM",
        'consumer_key' => "Zr397FLlTFM4RVBsoLVgA",
        'consumer_secret' => "3Z2wNAG2vvunam2mfJATxnJcThnqw1qu02Xy8QlqFI"
    );
    $url = 'https://api.twitter.com/1.1/statuses/user_timeline.json';
    $getfield = '?screen_name=' . $content . '&count=3';
    $requestMethod = 'GET';
    $twitter = new TwitterAPIExchange($settings);
    $tweets = json_decode($twitter->setGetfield($getfield)
                 ->buildOauth($url, $requestMethod)
                 ->performRequest());
    $return = '<section'.$parallax_id.' class="twitter text-center'.$parallax_class.$parallax_overlay_class.'" style="'.$style.'">';
    $return .= "<div class='container'>";
    $return .= "<div class='row'>";
    $return .= '<h2>'.$title.'</h2>';
    $return .= '<div id="twitter" data-ride="carousel" class="carousel slide">';
    $return .= "<div class='carousel-inner'>";
    $j=0;
    foreach( $tweets as $tweet ) {
        if($j=="0") {
            $class_active = ' active';
        } else {
            $class_active = '';
        }
        $tweet_text = $tweet->text;
        $tweet_text = preg_replace('/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '<a href="http://$1" target="_blank">http://$1</a>', $tweet_text); //replace links
        $tweet_text = preg_replace('/@([a-z0-9_]+)/i', '<a href="http://twitter.com/$1" target="_blank">@$1</a>', $tweet_text); //replace users
        $return .= '<div class="item'.$class_active.'">' . $tweet_text . '</div>';    
        $j++;
    }
    $return .= "</div>";
    $return .= "<ol class='carousel-indicators'>";
    for($i=0;$i<count($tweets);$i++) {
        if($i==0) {
            $active_class = "active";
        } else {
            $active_class = "";
        }
        $return .= "<li data-target='#twitter' data-slide-to='".$i."' class='".$active_class."'></li>";
    }
    $return .= "</ol>";
    $return .= "</div><a class='btn btn-md' href='http://twitter.com/".$content."'><i class='fa fa-twitter'></i>".__("Follow us", ANPS_TEMPLATE_LANG)."</a>";
    $return .= '</div></div></section>';
    return $return;
}
/* END Twitter */
/* Vimeo */
function anps_vimeo_func( $atts,  $content ) {
    return '<div class="video-wrapper"><iframe src="http://player.vimeo.com/video/' . $content . '" width="320" height="240" style="border: none !important"></iframe></div>';
}
/* END Vimeo */
/* Youtube */
function anps_youtube_func( $atts,  $content ) {
    return '<div class="video-wrapper"><iframe src="http://www.youtube.com/embed/' . $content . '?wmode=transparent" width="560" height="315" style="border: none !important"></iframe></div>';
}
/* END Youtube */
/* VC SHORTCODES */
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
if (!is_plugin_active( 'js_composer/js_composer.php')) {
    /* VC single image */
    function anps_vc_single_image($atts, $content) {
        extract( shortcode_atts( array(
            'image' => '',
            'border_color' => '',
            'img_link_target' => '',
            'img_size' => '',
            'el_class' => ''
        ), $atts ) ); 

        if($image) {
            $image_src = wp_get_attachment_image_src($image, 'full');
            $image_src = $image_src[0];
        }
        $data = "";
        $data .= "<img src='".$image_src."' />";
        return $data;
    }
    /* END VC single image */
    /* VC layer slider */
    function anps_vc_layer_slider($atts, $content) {
        return do_shortcode("[layerslider id='".$atts['id']."']");
    }
    /* END VC layer slider */
    /* VC rev slider */
    function anps_vc_rev_slider($atts, $content) {
        return do_shortcode("[rev_slider id='".$atts['alias']."']");
    }
    /* END VC rev slider */
    /* VC Row */
    function vc_theme_rows($atts, $content) {
        $extra_class = '';
            $extra_id = '';
            $matches = array();

            global $no_container, $row_inner, $text_only;

            if ( $row_inner ) {
                return vc_theme_rows_inner($atts, $content);
            }
            if ( $text_only ) {
                return do_shortcode( shortcode_unautop($content));
            }
            /* Check for any user added styles */
            $css = '';
            $style = "";
            if( isset($atts['css']) ) {
                $css = $atts['css'];
            }
            $temp = preg_match('/\.vc_custom_(.*?){(.*?)}/s', $css, $matches); 
            if(!empty($matches)) {
                $temp = $matches[1];
                $temp_style = $matches[2];

                if( $temp ) {
                    $extra_class .= ' vc_custom_' . $temp;

                }
                if($temp_style) {
                    $style = 'style="' . $temp_style . '"';
                }
            }

            /* Check for any user added classes */

            if(isset($atts['el_class']) && $atts['el_class']) {
                $extra_class .= ' '. $atts['el_class'];
            }

            /* Check for any user added IDs */

            if(isset($atts['id']) && $atts['id']) {
                $extra_id = 'id= "'. $atts['id'].'"';
            }

            $coming_soon = get_option('coming_soon', '0');

            if($coming_soon=="0"||is_super_admin()) {
                if(!isset($atts['has_content']) || $atts['has_content']=="true") {
                    /* Content inside a container */
                    $no_container = false;
                    return '<section class="container"><div '.$extra_id.' class="row' . $extra_class . '" '.$style.'>'.do_shortcode( shortcode_unautop($content)).'</div></section>';
                } 
                elseif($atts['has_content']=="inside") {
                    $no_container = false;
                    return '<section '.$extra_id.' class="' . $extra_class . '" '.$style.'><div class="container no-margin"><div class="row">'.do_shortcode( shortcode_unautop($content)).'</div></div></section>';
                }
                else {
                    /* Fullwidth Content */
                    $no_container = true;
                    return '<section '.$extra_id.' class="row no-margin' . $extra_class . '" '.$style.'>'.do_shortcode( shortcode_unautop($content)).'</section>';
                }
            } else {
                /* No wrappers, only when Cooming soon is active */
                $no_container = true;
                return do_shortcode( shortcode_unautop($content));
            }
    }
    function vc_theme_rows_inner($atts, $content) {
            /* Check for any user added styles */
            $style = "";
            $css = '';
            if( isset($atts['css']) ) {
                $css = $atts['css'];
            }
            $temp = preg_match('/{(.*?)}/s', $css, $matches);
            if(!empty($matches)) {
                $temp = $matches[1];
                if( $temp ) {
                    $style = 'style="' . $temp . '"';
                }
            }
            return '<div class="row"' . $style . '>'.do_shortcode( shortcode_unautop($content)).'</div>';
        }
    function vc_theme_vc_row($atts, $content = null) {
        return vc_theme_rows($atts, $content);
    }
    function vc_theme_vc_row_inner($atts, $content = null) {
        return vc_theme_rows_inner($atts, $content);
    }
    /* END VC row */
    /* VC Columns */
    function vc_theme_columns($atts, $content = null) {
        if( !isset($atts['width']) ) {
                $width = '1/1';
            } else {
                $width = explode('/', $atts['width']); 
            }

            global $no_container, $text_only;

            if($width[1] > 0) {
                $col = (12/$width[1])*$width[0];
            } else {
                $col = 12;
            }
            $extra_class = '';

            if(isset($atts['el_class']) && $atts['el_class']) {
                $extra_class = ' ' . $atts['el_class'];
            }

            if ( $no_container || $text_only ) {
                return do_shortcode( shortcode_unautop($content));
            } else {
                return '<div class="col-md-' . $col . $extra_class . '">'.do_shortcode( shortcode_unautop($content)).'</div>';
            }
    }
    /* END VC Column */
    /* VC Column Text */
    function vc_column_text_func($atts, $content = null) {
        return do_shortcode(force_balance_tags($content));
    }
    /* END VC Column text */
    /* VC Tabs */
    function vc_tabs_func ($atts, $content = null) {
        if(!isset($atts['type'])) {
            $atts['type'] = "";
        } else {
            $atts['type'] = $atts['type'];
        }
        $content2 = str_replace("vc_tab", "tab", $content);
        return do_shortcode("[tabs type='".$atts['type']."']".$content2."[/tabs]");
    }
    /* END VC Tabs */
}