<?php 
include_once 'classes/Style.php'; 
wp_enqueue_script('font_subsets');
/* Save form */
if(isset($_GET['save_style']))
    $style->save();
/* get all fonts */
$fonts = $style->all_fonts(); 
?>
<div class="content">
    <form action="themes.php?page=theme_options&save_style" method="post">
        <div class="content-top">
            <input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>">
            <div class="clear"></div>
        </div>
        <div class="content-inner">
            <h3><?php _e("Font family", ANPS_TEMPLATE_LANG); ?></h3>
            <div class="input">
                <label for="font_type_1">Font type 1</label>                    
                <select name="font_type_1" id="font_type_1">
                    <?php foreach($fonts as $name=>$value) : ?>
                    <optgroup label="<?php echo $name; ?>">
                    <?php foreach ($value as $font) : 
                            $selected = '';
                            if ($font['value'] == get_option('font_type_1', 'Arial, Helvetica, sans-serif')) {
                                $selected = 'selected="selected"';                
                                if($name=="Google fonts") {
                                    $subsets = $font['subsets'];
                                } else {
                                    $subsets = "";
                                }
                            }
                            ?>
                            <option value="<?php echo $font['value']."|".$name; ?>" <?php echo $selected; ?>><?php echo $font['name']; ?></option>
                    <?php endforeach; ?>
                    </optgroup>  
                    <?php endforeach; ?>
                </select>
                <div id="font_subsets_1" class="font_subsets">
                    <?php if($subsets) : 
                        $i=0;
                        foreach($subsets as $item) :
                            if(is_array(get_option("font_type_1_subsets"))&&in_array($item, get_option("font_type_1_subsets"))) {
                                $checked = " checked";
                            } else {
                                $checked = "";
                            }
                            ?>
                        <input type="checkbox" name="font_type_1_subsets[]" value="<?php echo $item; ?>" <?php echo $checked;?> /><?php echo $item; ?><br />
                        <?php $i++; 
                        endforeach; 
                    endif;
                    ?>
                </div>
            </div>
            <div class="input">
                <label for="font_type_2"><?php _e("Font type 2", ANPS_TEMPLATE_LANG); ?></label>
                <select name="font_type_2" id="font_type_2">
                    <?php foreach($fonts as $name=>$value) : ?>
                    <optgroup label="<?php echo $name; ?>">
                    <?php foreach ($value as $font) :
                            $selected = '';
                            if ($font['value'] == get_option('font_type_2', 'Arial, Helvetica, sans-serif')) {
                                $selected = 'selected="selected"';
                                if($name=="Google fonts") {
                                    $subsets2 = $font['subsets'];
                                } else {
                                    $subsets2 = "";
                                }
                            }
                            ?>
                            <option value="<?php echo $font['value']."|".$name; ?>" <?php echo $selected; ?>><?php echo $font['name']; ?></option>
                    <?php endforeach; ?>
                    </optgroup>  
                    <?php endforeach; ?>
                </select>
                <div id="font_subsets_2" class="font_subsets">
                    <?php if($subsets2) : 
                        $i=0;
                        foreach($subsets2 as $item) :
                            if(is_array(get_option("font_type_2_subsets"))&&in_array($item, get_option("font_type_2_subsets"))) {
                                $checked = " checked";
                            } else {
                                $checked = "";
                            }
                            ?>
                        <input type="checkbox" name="font_type_2_subsets[]" value="<?php echo $item; ?>" <?php echo $checked;?> /><?php echo $item; ?><br />
                        <?php $i++; 
                        endforeach; 
                    endif;
                    ?>
                </div>
            </div>
            <br /><hr /><br />
            <h3><?php _e("Predefined color Scheme", ANPS_TEMPLATE_LANG); ?></h3>
            <p><?php _e("Selecting one of this schemes will import the predefined colors below, which you can then edit as you like.", ANPS_TEMPLATE_LANG); ?></p>
            <br /><br />
            <select name="predefined_colors" id="predefined_colors">
                <option></option>
                <option value="default">Default</option>
                <option value="green">Green</option>
                <option value="blue">Blue</option>
                <option value="violet">Violet</option>
                <option value="red">Red</option>
            </select>
            <br /><br /><br /><hr />
            <h3><?php _e("Main theme colors", ANPS_TEMPLATE_LANG); ?></h3>
            <div class="input">
                <label for="text_color"><?php _e("Text color", ANPS_TEMPLATE_LANG); ?></label>
                <input data-value="<?php echo get_option('text_color', '#727272'); ?>" readonly style="background: <?php echo get_option('text_color', '#727272'); ?>" class="color-pick-color"><input class="color-pick" type="text" name="text_color" value="<?php echo get_option('text_color', '#727272'); ?>" id="text_color" />
            </div>
            <div class="input">
                <label for="primary_color"><?php _e("Primary color", ANPS_TEMPLATE_LANG); ?></label>
                <input data-value="<?php echo get_option('primary_color', '#ff9c00'); ?>" readonly style="background: <?php echo get_option('primary_color', '#ff9c00'); ?>" class="color-pick-color"><input class="color-pick" type="text" name="primary_color" value="<?php echo get_option('primary_color', '#ff9c00'); ?>" id="primary_color" />
            </div>
            <div class="input">
                <label for="headings_color"><?php _e("Headings color", ANPS_TEMPLATE_LANG); ?></label>
                <input data-value="<?php echo get_option('headings_color', '#363636'); ?>" readonly style="background: <?php echo get_option('headings_color', '#363636'); ?>" class="color-pick-color"><input class="color-pick" type="text" name="headings_color" value="<?php echo get_option('headings_color', '#363636'); ?>" id="headings_color" />
            </div>                            
            <br/><br/><br/><br/><br/>
        </div>
        <div class="content-top" style="border-style: solid none">
            <input type="submit" value="<?php _e("Save all changes", ANPS_TEMPLATE_LANG); ?>">
            <div class="clear"></div>
        </div>
    </form>
    <div class="clear"></div>    
</div>