<?php

class AnpsImage extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'AnpsImages', 'AnpsThemes - Images', array('description' => __('Choose a image to show on page', ANPS_TEMPLATE_LANG),)
        );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => '', 'image' => ''));

        $image = $instance['image'];
        $title = $instance['title'];
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Title", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />
        </p>

        <?php $images = get_children('post_type=attachment&post_mime_type=image'); ?>

        <select id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>">
            <option value="">Select an image</option>
            <?php foreach ($images as $item) : ?>
                <option <?php if ($item->guid == $image) {
                    echo 'selected="selected"';
                } ?> value="<?php echo $item->guid; ?>"><?php echo $item->post_title; ?></option>
        <?php endforeach; ?>
        </select>
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['image'] = $new_instance['image'];
        $instance['title'] = $new_instance['title'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $image = $instance['image'];
        echo $before_widget;
        $size = getimagesize($image);
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif; ?>

        <img alt="<?php echo $image; ?>" src="<?php echo $image; ?>" width="<?php echo $size[0]/2; ?>" height="<?php echo $size[1]/2; ?>"/>

        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsImage");') );
