<?php

class AnpsRecentComments extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'AnpsRecentComments', 'AnpsThemes - Recent Comments', array('description' => __('Anps recent comments', ANPS_TEMPLATE_LANG), 'classname'=>"recent-comments-widget recent-widget")
        );
    }
    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => '', 'number' => ''));

        $number = $instance['number'];
        $title = $instance['title'];
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Title", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e("Number of comments to show:", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" size="3" value="<?php echo $instance['number']; ?>" />
        </p>
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['number'] = $new_instance['number'];
        $instance['title'] = $new_instance['title'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $number = $instance['number'];
        $args = 
        $comments = get_comments(array('number'=>$number));
        echo $before_widget;
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif; ?>
            <ul>
                <?php foreach($comments as $item) : 
                    $post_title = get_post($item->comment_post_ID);
                    ?>
                <li>
                    <h5><?php echo $post_title->post_title; ?></h5>
                    <p><?php echo substr($item->comment_content, 0, 45)?></p>
                    <span class="post-date"><?php echo date("d.m.Y", strtotime($item->comment_date)); ?></span>
                    <a href="<?php echo get_permalink( $post_title->ID ); ?>"><?php _e("read more", ANPS_TEMPLATE_LANG);?><i class="fa fa-long-arrow-right"></i></a>
                </li>
                <?php endforeach; ?>
            </ul>
        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsRecentComments");') );
