<?php
class AnpsTabs extends WP_Widget {
    public function __construct() {
        parent::__construct(
                'AnpsTabs', 'AnpsThemes - Tabs', array('description' => __('Tabs widget', ANPS_TEMPLATE_LANG),)
        );
    }
    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title'=>'','title1' => '', 'title2' => '', 'text1' => '', 'text2' => ''));
        
        $title = $instance['title'];
        $title1 = $instance['title1'];
        $title2 = $instance['title2'];
        $text1 = $instance['text1'];
        $text2 = $instance['text2'];
        ?>
        
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Widget Title:", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />          
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('title1'); ?>"><?php _e("Tab 1 Title:", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title1'); ?>" name="<?php echo $this->get_field_name('title1'); ?>" type="text" class="widefat" value="<?php echo $instance['title1']; ?>" />          
        </p>
        <label for="<?php echo $this->get_field_id('text1'); ?>"><?php _e("Tab 1 Text:", ANPS_TEMPLATE_LANG); ?></label>
        <textarea name="<?php echo $this->get_field_name('text1'); ?>" id="<?php echo $this->get_field_id('text1'); ?>" cols="20" rows="6" class="widefat"><?php echo $instance['text1']; ?></textarea>
        <p>
            <label for="<?php echo $this->get_field_id('title2'); ?>"><?php _e("Tab 2 Title:", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title2'); ?>" name="<?php echo $this->get_field_name('title2'); ?>" type="text" class="widefat" value="<?php echo $instance['title2']; ?>" />          
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('text2'); ?>"><?php _e("Tab 2 Text:", ANPS_TEMPLATE_LANG); ?></label>
            <textarea name="<?php echo $this->get_field_name('text2'); ?>" id="<?php echo $this->get_field_id('text2'); ?>" cols="20" rows="6" class="widefat"><?php echo $instance['text2']; ?></textarea>
        </p>
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['title1'] = $new_instance['title1'];
        $instance['title2'] = $new_instance['title2'];
        $instance['text1'] = $new_instance['text1'];
        $instance['text2'] = $new_instance['text2'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $title1 = $instance['title1'];
        $title2 = $instance['title2'];
        $text1 = $instance['text1'];
        $text2 = $instance['text2'];
        wp_enqueue_script('tab');
        echo $before_widget;
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif; ?>

        <ul class="nav nav-tabs style-2">
            <li class="active"><a href="#tab-widget-0" data-toggle="tab"><?php echo $title1; ?></a></li>
            <li><a href="#tab-widget-1" data-toggle="tab"><?php echo $title2; ?></a></li>
        </ul>
        <div class="tab-content">
            <div id="tab-widget-0" class="tab-pane active">
                <p><?php echo $text1; ?></p>
            </div>
            <div id="tab-widget-1" class="tab-pane">
                <p><?php echo $text2; ?></p>
            </div>
        </div>

        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsTabs");') );