<?php

class AnpsTestimonials extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'AnpsTestimonials', 'AnpsThemes - Testimonials', array('description' => __('Show testimonials on site.', ANPS_TEMPLATE_LANG),)
        );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('title' => '', 'title1' => '', 'text1' => '', 'user1' => '', 'title2' => '', 'text2' => '', 'user2' => '', 'title3' => '', 'text3' => '', 'user3' => ''));
        
        $title = $instance['title'];
        $text1 = $instance['text1'];
        $title1 = $instance['title1'];
        $user1 = $instance['user1'];
        $text2 = $instance['text2'];
        $title2 = $instance['title2'];
        $user2 = $instance['user2'];
        $text3 = $instance['text3'];
        $title3 = $instance['title3'];
        $user3 = $instance['user3'];
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e("Widget Title", ANPS_TEMPLATE_LANG); ?></label>
            <input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" class="widefat" value="<?php echo $instance['title']; ?>" />
        </p>
        <?php for($i=1;$i<=3;$i++) : 
            $title = "title".$i;
            $text = "text".$i;
            $user = "user".$i;
            ?>
            <p>
                <label for="<?php echo $this->get_field_id($title); ?>"><?php _e("Title $i", ANPS_TEMPLATE_LANG); ?></label>
                <input id="<?php echo $this->get_field_id($title); ?>" name="<?php echo $this->get_field_name($title); ?>" type="text" class="widefat" value="<?php echo $instance[$title]; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id($user); ?>"><?php _e("User $i", ANPS_TEMPLATE_LANG); ?></label>
                <input id="<?php echo $this->get_field_id($user); ?>" name="<?php echo $this->get_field_name($user); ?>" type="text" class="widefat" value="<?php echo $instance[$user]; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id($text); ?>"><?php _e("Text $i", ANPS_TEMPLATE_LANG); ?></label>
                <textarea id="<?php echo $this->get_field_id($text); ?>" name="<?php echo $this->get_field_name($text); ?>" cols="20" rows="6" class="widefat"><?php echo $instance[$text]; ?></textarea>
            </p>
        <?php
                endfor;
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['text1'] = $new_instance['text1'];
        $instance['title1'] = htmlentities($new_instance['title1']);
        $instance['user1'] = $new_instance['user1'];
        $instance['text2'] = $new_instance['text2'];
        $instance['title2'] = htmlentities($new_instance['title2']);
        $instance['user2'] = $new_instance['user2'];
        $instance['text3'] = $new_instance['text3'];
        $instance['title3'] = htmlentities($new_instance['title3']);
        $instance['user3'] = $new_instance['user3'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $title = $instance['title'];
        $text1 = $instance['text1'];
        $title1 = html_entity_decode($instance['title1']);
        $user1 = $instance['user1'];
        $text2 = $instance['text2'];
        $title2 = html_entity_decode($instance['title2']);
        $user2 = $instance['user2'];
        $text3 = $instance['text3'];
        $title3 = html_entity_decode($instance['title3']);
        $user3 = $instance['user3'];
        $counter = 0;
        if($user1!="" || $title1!="" || $text1!="") {
            $counter++;
        } 
        if($user2!="" || $title2!="" || $text2!="") {
            $counter++;
        }
        if($user3!="" || $title3!="" || $text3!="") {
            $counter++;
        } 
        echo $before_widget;
        ?>

        <?php if($title) : ?>
            <h3 class="widget-title"><?php echo $title; ?></h3>
        <?php endif; ?>

        <div id="testimonials" data-ride="testimonials" class="carousel slide testimonials">
            <div class="carousel-inner">
                <?php for($i=1;$i<=$counter;$i++) : 
                    $text = ${"text".$i};
                    $user = ${"user".$i};
                    $title = ${"title".$i};
                    ?>
                <div class="item<?php if($i=="1"){echo " active";}?>">
                    <?php echo $text; ?>
                    <h5><?php echo $user; ?></h5>
                    <h6 class="style-2"><?php echo $title; ?></h6>
                </div>
                <?php endfor; ?>
            </div>
            <?php if($counter>1) : ?>
                <ol class="carousel-indicators">
                    <?php for($i=0;$i<$counter;$i++) : 
                        $class = ' class="active"';
                        ?>
                        <li data-target="#testimonials" data-slide-to="<?php echo $i; ?>"<?php if($i=="0"){echo $class;}?>></li>
                    <?php endfor; ?>
                </ol>
            <?php endif; ?>
          </div>
        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsTestimonials");') );
