<?php 
/* number of sidebars */
$meta = get_post_meta(get_queried_object_id()); 
$num_of_sidebars = 0;
$left_sidebar = 0;
if (isset($meta['sbg_selected_sidebar'])) {
    $left_sidebar = $meta['sbg_selected_sidebar'];
    if($left_sidebar[0] != "0") {
        $num_of_sidebars++;   
    }
}
$right_sidebar = 0;
if (isset($meta['sbg_selected_sidebar_replacement'])) {
    $right_sidebar = $meta['sbg_selected_sidebar_replacement'];
    if($right_sidebar[0] != "0") {
        $num_of_sidebars++;   
    }
} 
if($num_of_sidebars=="0") {
    $image_class = "blog-full";
} else {
    $image_class = "blog-one-sidebar";
} 
/* get blog categories */ 
$post_categories = wp_get_post_categories(get_the_ID());
?>
<header>
    <?php echo anps_header_media_single(get_the_ID(), 'blog-full'); ?> 
    <h2><?php the_title();?></h2>
    <div class="post-meta">
        <ul>
            <li><i class='fa fa-user'></i><?php echo __("posted by", ANPS_TEMPLATE_LANG)." <a href='".get_author_posts_url(get_the_author_meta('ID'))."'>".get_the_author()."</a>"; ?></li>
            <li><i class='fa fa-calendar-o'></i><?php echo get_the_date("jS M Y"); ?></li>
            <li><i class='fa fa-comment-o'></i><a href='<?php echo get_permalink() . "#comments"; ?>'><?php echo __("comments", ANPS_TEMPLATE_LANG)." [ ".get_comments_number()." ] "; ?></a></li>
            <li><i class='fa fa-folder-o'></i>
                <?php $first_item = false;
                    foreach($post_categories as $c) {
                        $cat = get_category($c); 
                        if($first_item) {
                            echo " / ";
                        }
                        $first_item = true;
                        echo "<a href='".get_category_link($c)."'>".$cat->name."</a>";
                } ?>
            </li>
            <?php if( has_tag() ): ?>
                <li><i class="fa fa-folder-open-o"></i>
                    <?php
                        the_tags( '' );
                    ?>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</header>
<p><?php the_content(); ?></p>
<?php if( get_the_author_meta('description',get_the_author_meta('ID')) != "" ): ?>
    <div class="author"><?php echo get_avatar(get_the_author_meta('ID'), 174); ?>
        <div>
            <h4><?php _e("about author",ANPS_TEMPLATE_LANG);?> <span class="color"><?php echo get_the_author(); ?></span></h4>
            <p><?php echo get_the_author_meta('description',get_the_author_meta('ID'));?></p>
        </div>
    </div>
<?php endif; ?>