<?php
    header("Content-type: text/css; charset: UTF-8");
    require_once('../../../../wp-load.php');

    $text_color = get_option('text_color', '#727272');
    $primary_color = get_option('primary_color', '#ff9c00');
    $headings_color = get_option('headings_color', '#363636');
?>
/* =Fonts
-------------------------------------------------------------- */
<?php
function anps_getExtCustomFonts($font) {
    $dir = get_template_directory().'/fonts';
        if ($handle = opendir($dir)) {
            $arr = array();
            // Get all files and store it to array
            while(false !== ($entry = readdir($handle))) {
                $explode_font=explode('.',$entry);
                if(strtolower($font)==strtolower($explode_font[0]))
                    $arr[] = $entry;
            }
            closedir($handle);
            // Remove . and ..
            unset($arr['.'], $arr['..']);
            return $arr;
        }
}
$fonts = get_option('font_type_1', "pacifico-webfont");
$type = 1;
$fonts2 = get_option('font_type_2', "Open Sans, sans-serif");
$type2 = 0;
switch(get_option('font_source_1')) {
    case('System fonts') :
        $fonts = urldecode(get_option('font_type_1'));
        $type = 0;
        break;
    case('Custom fonts') :
        $fonts = urldecode(get_option('font_type_1'));
        $type = 1;
        break;
    case('Google fonts') :
        $fonts = urldecode(get_option('font_type_1'));
        $type = 2;
        break;
}
switch(get_option('font_source_2')) {
    case('System fonts') :
        $fonts2 = urldecode(get_option('font_type_2'));
        $type2 = 0;
        break;
    case('Custom fonts') :
        $fonts2 = urldecode(get_option('font_type_2'));
        $type2 = 1;
        break;
    case('Google fonts') :
        $fonts2 = urldecode(get_option('font_type_2'));
        $type2 = 2;
        break;
}
?>
<?php if($type==1) : ?>
  @font-face {
    font-family: '<?php echo $fonts ?>';
    src: url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $fonts; ?>.eot');
    src: <?php foreach(anps_getExtCustomFonts($fonts) as $item) : ?>
                    <?php $explode_item = explode(".", $item);
                    if($explode_item[1]=='eot') : ?>
                    url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $explode_item[0]; ?>.eot?#iefix') format('embedded-opentype'),
                    <?php endif;
                    if($explode_item[1]=='woff') : ?>
                    url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $explode_item[0]; ?>.woff') format('woff'),
                    <?php endif;
                    if($explode_item[1]=='ttf') : ?>
                    url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $explode_item[0]; ?>.ttf') format('truetype');
                <?php endif;
                endforeach; ?>
  }
<?php endif; ?>
<?php if($type2==1) : ?>
  @font-face {
    font-family: '<?php echo $fonts2 ?>';
    src: url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $fonts2; ?>.eot');
    src: <?php foreach(anps_getExtCustomFonts($fonts2) as $item) : ?>
                    <?php $explode_item = explode(".", $item);
                    if($explode_item[1]=='eot') : ?>
                    url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $explode_item[0]; ?>.eot?#iefix') format('embedded-opentype'),
                    <?php endif;
                    if($explode_item[1]=='woff') : ?>
                    url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $explode_item[0]; ?>.woff') format('woff'),
                    <?php endif;
                    if($explode_item[1]=='ttf') : ?>
                    url('<?php echo get_template_directory_uri(); ?>/fonts/<?php echo $explode_item[0]; ?>.ttf') format('truetype');
                <?php endif;
                endforeach; ?>
  }
<?php endif; ?>
/* Font Family 1 (headings) */
h1, h2, h3, h4, h5, h6,
.site-navigation,
.btn,
.dropcaps:first-letter,
.pricing-table header,
.blog-loop.columns article header,
.filter,
.blog-single .comment-list li header,
.order-menu .food-item.price-right header .anps_quantity,
.countdown,
div.productwrap span.price span.amount, .price span.amount
.shop-categories a,
.woocommerce-page div.productwrap a.button.add_to_cart_button, .woocommerce-page div.productwrap a.button.product_type_simple, .woocommerce-page div.productwrap a.button.product_type_variable, .woocommerce-page div.productwrap a.button.product_type_grouped, .woocommerce-page div.productwrap a.button,
.woocommerce a.button,
.woocommerce button.single_add_to_cart_button,
body.single-product .comment_container p.meta,
.shop-categories a,
div#review_form div#respond.comment-respond p.form-submit input#submit,
div.productwrap span.price span.amount, .price span.amount,
body.woocommerce.woocommerce-cart td.product-name a, body.woocommerce.woocommerce-cart .cart_totals a, body.woocommerce.woocommerce-cart div.cart_totals span.amount, body.woocommerce.woocommerce-cart a.shipping-calculator-button, .product-single-header p.price,
a.vc_btn.kataleya {
  font-family: <?php echo $fonts; ?>; }

/* Font Family 2 (main texts) */
body,
input[type="text"],
input[type="tel"],
input[type="email"],
input[type="password"],
textarea,
h1.style-2, h2.style-2, h3.style-2, h4.style-2, h5.style-2, h6.style-2,
.panel-title,
.recent-widget ul li > h5,
.woocommerce-tabs .commentlist .meta {
  font-family: <?php echo $fonts2; ?>; }

/* =Text Colors
-------------------------------------------------------------- */
/* main text color */
body,
.widget-container .twitter {
  color: <?php echo $text_color; ?>; }

@media (min-width: 992px) {
  .responsive .site-navigation .sub-menu a, .responsive .site-navigation .children a {
    color: <?php echo $text_color; ?>; } }

/* light text color */
.site-navigation li > a,
.btn,
.btn:hover,
mark,
.pricing-table .price,
.icon .fa,
span.page-numbers,
.active .page-numbers,
a.page-numbers:hover,
.tagcloud a:hover,
.jumbotron h5,
.jumbotron.style-2 .color.style-2,
.posts article > a .hover,
.blog-loop.columns article header a,
.blog-loop.columns article header i,
.form-date input[type="text"], .form-date input[type="tel"], .form-date input[type="email"], .form-date input[type="number"], .form-date input[type="password"], .form-date textarea, .form-date select,
.twitter,
.ls-container,
.ls-kataleya .ls-nav-prev,
.ls-kataleya .ls-nav-next,
.posts article > a i,
a.carousel-control i,
a.carousel-control:hover i,
.menu-dark.sticky-scroll .site-navigation > li > a,
.menu-dark.sticky-scroll div.site-navigation > ul > li > a,
.btn:focus,
a.btn i.fa ,
a.btn:hover i,
.coming-soon *,
a.pp_close {
  color: #fff; }

/* headings */
h1, h2, h3, h4, h5, h6,
.page-heading ul li a,
.dropcaps:first-letter,
div.style-2 .page-numbers a,
.page-numbers.style-2 a,
.nav-tabs > li a,
.panel .panel-heading a.collapsed,
.jumbotron.style-2,
a:hover, a:focus,
blockquote,
.searchform button,
.social a:hover,
.color.style-2,
.filter button,
.landing-icons a i,
.blog-single .comment-list li header,
.blog-single .comment-list li h5:after,
.blog-single .comment-list li a,
.recent-widget ul li > h5,
.recent-widget ul li > .post-date,
.woocommerce-tabs .commentlist .meta,
a:hover i {
  color: <?php echo $headings_color; ?>; }

.btn.style-2.secondary,
.btn.style-2:hover,
.btn.style-2:focus {
  color: <?php echo $headings_color; ?> !important; }

strong {
  color: #000; }

<?php
  global $anps_options_data;
  if( isset($anps_options_data['hide_slider_on_mobile']) && $anps_options_data['hide_slider_on_mobile'] == 'on' ):
?>
@media (max-width: 786px) {
    .wpb_layerslider_element, .wpb_revslider_element {
        display: none;
    }
}
<?php endif; ?>

@media (min-width: 992px) {
  .menu-dark .site-navigation li > a {
    color: #000; } }
/* primary color */
a,
.color,
div.site-navigation ul > li a:hover,
.site-navigation > li a:hover,
.site-navigation li.active > a,
.site-navigation li.current_page_item > a,
.site-navigation .sub-menu a:hover,
.site-navigation .children a:hover,
.page-heading ul li span,
.dropcaps.style-2:first-letter,
.list li:before,
i.fa,
.pricing-table.style-2 header,
div.style-2 .page-numbers a.page-numbers:hover,
.page-numbers.style-2 a.page-numbers:hover,
.nav-tabs > li.active a,
.nav-tabs > li a:hover,
.nav-tabs > li.active > a:hover,
.vc_tta-tabs-list > li.vc_active > a span,
.panel .panel-heading a,
.panel .panel-heading a:hover,
.food-item .price,
.landing-page a:hover h4,
.landing-page a:hover h5,
blockquote:before,
.site-footer .copyright .social a:hover,
a:hover h2,
.filter li,
.filter li button.selected,
.menu-dark .site-navigation li.active > a,
.blog-single .comment-list li h5,
.blog-single .comment-list li a:hover,
.order-menu .food-item.price-right header .anps_quantity .minus,
.order-menu .food-item.price-right header .anps_quantity .plus,
.food-item.active header h3,
.order-menu-wrapper .close-order,
.search-posts li a:hover i,
.search-posts li a:hover h4,
.woocommerce .page-heading ul li,
#reviews .stars a:hover, #reviews .stars a:focus, #reviews .stars a.active,
.woocommerce .star-rating span, .woocommerce-page .star-rating span, div.product form#commentform p.stars span,
div.productwrap span.price span.amount,
.shop-categories a.shop-selected,
span.linkcolor,
body.single-product .comment_container p.meta > strong,
div.productwrap span.price span.amount, .price span.amount,
table.variations td.value select, .single_variation span.price del, .single_variation span.price ins,
div.pp_woocommerce .pp_close:before,
div.productwrap span.price del, div.productwrap span.price ins,
body.woocommerce.woocommerce-cart td.product-name a, body.woocommerce.woocommerce-cart .cart_totals a, body.woocommerce.woocommerce-cart div.cart_totals span.amount, body.woocommerce.woocommerce-cart a.shipping-calculator-button, .product-single-header p.price,
a.vc_btn.kataleya,
.woocommerce-tabs .commentlist .meta strong,
.product.product-category mark,
.woocommerce-account .sidebar .menu a:hover,
.woocommerce-account .sidebar .menu a:focus,
.woocommerce-account .sidebar .menu .is-active a,
.widget_price_filter .price_slider_amount .from,
.widget_price_filter .price_slider_amount .to {
  color: <?php echo $primary_color; ?>; }

.icon span {
  color: #bfbfbf; }

.btn.style-2.danger {
  color: #f95f22; }

.btn.style-2.success {
  color: #87c73c; }

/* =Background Colors
-------------------------------------------------------------- */
.site-header .navbar-header button,
.btn,
mark,
.pricing-table header,
.icon .fa,
span.page-numbers,
.active .page-numbers,
a.page-numbers:hover,
div.style-2 .page-numbers span.page-numbers,
.page-numbers.style-2 span.page-numbers,
.tagcloud a:hover,
.nav-tabs.style-2 > li.active:before,
.vc_tta-style-anps_tabs .vc_tta-tabs-list > li.vc_active:after,
.posts article > a:before,
.form-date input[type="text"], .form-date input[type="tel"], .form-date input[type="email"], .form-date input[type="number"], .form-date input[type="password"], .form-date textarea, .form-date select,
.twitter .carousel-indicators li.active,
.twitter .carousel-indicators li.active:hover,
.testimonials .carousel-indicators li.active,
.testimonials .carousel-indicators li.active:hover,
.ls-kataleya .ls-nav-prev,
.ls-kataleya .ls-nav-next,
.ls-kataleya .ls-bottom-slidebuttons a:hover,
.ls-kataleya .ls-bottom-slidebuttons a.ls-nav-active,
.carousel.post-images .carousel-indicators li:hover,
.carousel.post-images .carousel-indicators li.active,
.blog-loop.columns article header:before,
.flickr-widget a:after,
.widget-container .twitter .carousel-indicators li.active,
.testimonials .carousel-indicators li.active,
a.carousel-control i,
.order-menu-wrapper .close-order:after,
.order-menu-wrapper .order-menu .mobile-close,
.countdown li span,
.woocommerce button.single_add_to_cart_button,
div#review_form div#respond.comment-respond p.form-submit input#submit,
.woocommerce a.button,
.woo-header-cart .cart-contents > span,
.woocommerce .product .product_meta .posted_in a:hover, .woocommerce .product .product_meta .tagged_as a:hover,
.woocommerce ul.products li.product .onsale, .woocommerce-page ul.products li.product .onsale,
body.woocommerce.woocommerce-cart input.checkout-button,
#content form.cart .quantity .minus, #content form.cart  .quantity .plus, form.cart .quantity .minus, form.cart .quantity .plus, table.shop_table .quantity .minus, table.shop_table .quantity .plus,
.shipping-calculator-form button, .btn:hover,
.lost_reset_password input.button:hover,
a.vc_btn.kataleya,
.woocommerce span.onsale, .woocommerce-page span.onsale,
div.woocommerce-tabs ul.tabs li.active:before,
.widget_price_filter .ui-slider .ui-slider-range
 {
  background-color: <?php echo $primary_color; ?>;
  }

.vc_btn3.vc_btn3-color-juicy-pink, .vc_btn3.vc_btn3-color-juicy-pink.vc_btn3-style-flat {
  background-color: <?php echo $primary_color; ?> !important;
}

a.pp_close {
  background: <?php echo $primary_color; ?> !important; }

.mini-logo *,
.mini-logo-2 *,
.mini-logo-3 * {
  fill: <?php echo $primary_color; ?>; }

mark.style-2,
.twitter .carousel-indicators li:hover,
.testimonials .carousel-indicators li:hover,
.ls-kataleya .ls-nav-prev:hover,
.ls-kataleya .ls-nav-next:hover,
.widget-container .twitter .carousel-indicators li,
.testimonials .carousel-indicators li,
a.carousel-control:hover i {
  background-color: <?php echo $headings_color; ?>; }

.btn.secondary,
.btn:hover,
.btn:focus,
.woocommerce a.button:hover, .woocommerce button.button:hover, div#review_form div#respond.comment-respond p.form-submit input#submit:hover,
.quantity .plus:hover, .quantity .minus:hover, .woocommerce input.button:hover, a.vc_btn.kataleya:hover

{
  background-color: <?php echo $headings_color; ?> !important;
}

.woocommerce input.button[name="update_cart"] {
  background-color: <?php echo $headings_color; ?>;
}
.woocommerce input.button[name="update_cart"]:disabled {
  background-color: <?php echo $headings_color; ?> !important;
}

.woocommerce input.button[name="update_cart"]:not(:disabled):hover,
.woocommerce input.button[name="update_cart"]:not(:disabled):focus {
  background-color: <?php echo $primary_color; ?> !important;
}

.site-header,
.pricing-table.style-2 header,
.pricing-table.style-2 .btn {
  background-color: #2e1e1f; }

@media (min-width: 992px) {
  .responsive .site-navigation .sub-menu, .responsive .site-navigation .children {
    background-color: #fff; } }
@media (max-width: 992px) {
  .responsive .site-navigation {
    background-color: #333; } }

.site-header .navbar-header button:hover {
  background-color: #333; }

::-moz-selection {
  color: #fff;
  background-color: <?php echo $primary_color; ?>; }

::selection {
  color: #fff;
  background-color: <?php echo $primary_color; ?>; }

.ls-kataleya .ls-bottom-slidebuttons a,
.carousel.post-images .carousel-indicators li,
.blog-loop article,
.blog-loop article .post-inner,
.twitter .carousel-indicators li {
  background-color: #fff; }

.btn.danger {
  background-color: #f95f22; }

.btn.success {
  background-color: #87c73c; }

/* =Border Colors
-------------------------------------------------------------- */
.form-date input[type="text"]:focus,
.form-date input[type="tel"]:focus,
.form-date input[type="email"]:focus,
.form-date input[type="number"]:focus,
.form-date input[type="password"]:focus,
.form-date textarea:focus,
.form-date select:focus {
  border: 1px solid rgba(0, 0, 0, 0.25); }

.form-date input[type="text"],
.form-date input[type="tel"],
.form-date input[type="email"],
.form-date input[type="number"],
.form-date input[type="password"],
.form-date textarea:focus,
.form-date select
 {
  border: 1px solid <?php echo $primary_color; ?>; }

input[type="text"]:focus,
input[type="tel"]:focus,
input[type="search"]:focus,
input[type="email"]:focus,
input[type="number"]:focus,
input[type="password"]:focus,
textarea:focus, select:focus {
  border: 1px solid <?php echo $primary_color; ?>; }

@media (min-width: 992px) {
  .responsive .site-navigation .sub-menu, .responsive .site-navigation .children {
    border-color: <?php echo $primary_color; ?> !important; } }

.nav-tabs > li.active {
  border-bottom-color: <?php echo $primary_color; ?>; }

.blog-single .comment-list li img,
.blog-single .author img,
.recent-posts-widget ul li img,
body.single-product .comment_container img.avatar {
  border-color: <?php echo $primary_color; ?>; }


 .btn:focus, .btn.btn-md:focus {
  border-color: <?php echo $headings_color; ?>; }
