<?php
/***************************************************************************
 *						Theme Modules
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						http://themify.me
 *
 *  To add custom modules to the theme, create a new 'custom-modules.php' file in the theme folder.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/**
 * Markup for theme design options
 * @param array $data
 * @return string
 */
function themify_theme_design_controls( $data = array() ) {
	/**
	 * Module markup
	 * @var string
	 */
	$html = '';
	$html .= '<div class="themify-info-link">'. __( 'Here you can set the theme appearance site-wide. The appearance settings here can be override on individual post/page &gt; edit &gt; Themify Custom Panel  &gt; Page Appearance).', 'themify' ) .'</div>';

	/**
	 * Theme Color
	 * @var array
	 */
	$design_options = themify_theme_color_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-color_design';

	/**
	 * Theme Color
	 */
	$html .= '<p>
					<span class="label">' . __( 'Theme Color', 'themify' ) . '</span>';
	$val = themify_check( $pre ) ? themify_get( $pre ) : '';
	foreach ( $design_options as $option ) {
		if ( ( '' == $val || ! $val ) && $option['selected'] ) {
			$val = $option['value'];
		}

		$class = ( $val == $option['value'] ) ? 'selected' : '';

		$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}

	$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Typography
	 * @var array
	 */
	$design_options = themify_theme_font_design_options();
	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-font_design';

	/**
	 * Typography
	 */
	$html .= '<p>
					<span class="label">' . __( 'Typography', 'themify' ) . '</span>';
	$val = themify_check( $pre ) ? themify_get( $pre ) : '';
	foreach ( $design_options as $option ) {
		if ( ( '' == $val || ! $val ) && $option['selected'] ) {
			$val = $option['value'];
		}

		$class = ( $val == $option['value'] ) ? 'selected' : '';

		$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}

	$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Header Design
	 * @var array
	 */
	$design_options = themify_theme_header_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-header_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none header-leftpane header-slide-out header-minbar boxed-content header-rightpane">';

		/**
		 * Header Design
		 */
		$html .= '<p class="clearfix">
						<span class="label">' . __( 'Header Design', 'themify' ) . '</span>';
		$val = themify_check( $pre ) ? themify_get( $pre ) : 'header-block';
		$html .= '<span class="preview-icon-wrapper">';
		unset( $design_options[0] );
		foreach ( $design_options as $option ) {
			$class = ( $val == $option['value'] ) ? 'selected' : '';

			$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />';
		$html .= '</span>';
					'</p>';

		/**
		 * Fixed header
		 */
		$html .= sprintf('<p class="hide-if none header-leftpane header-slide-out header-minbar boxed-content header-rightpane pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-fixed_header_disabled',
			checked( themify_get( 'setting-fixed_header_disabled' ), 'on', false ),
			__('Disable Sticky Header.', 'themify')
		);

		/**
		 * Full height header
		 */
		$key = 'setting-full_height_header';
		$html .= sprintf('<p
class="hide-if none header-horizontal header-leftpane header-minbar boxed-layout boxed-content boxed-layout boxed-compact header-rightpane header-slide-out header-top-bar header-stripe header-menu-split header-overlay pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s value="yes"/> %3$s</label>
			<br><small>%4$s</small>
			</p>',
			$key,
			checked( themify_get( $key ), 'yes', false ),
			__( 'Full Height Header.', 'themify' ),
			__( 'Full height will display the container in 100% viewport height', 'themify' )
		);

		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_logo',
			checked( themify_get( 'setting-exclude_site_logo' ), 'on', false ),
			__('Exclude Site Logo.', 'themify')
		);

		/**
		 * Exclude Site Tagline
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_tagline',
			checked( themify_get( 'setting-exclude_site_tagline' ), 'on', false ),
			__('Exclude Site Tagline.', 'themify')
		);

		/**
		 * Exclude Search Form
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_search_form',
			checked( themify_get( 'setting-exclude_search_form' ), 'on', false ),
			__('Exclude Search Form.', 'themify')
		);

		/**
		 * Exclude RSS Link
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_rss',
			checked( themify_get( 'setting-exclude_rss' ), 'on', false ),
			__('Exclude RSS Link.', 'themify')
		);

		/**
		 * Exclude Header Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_header_widgets',
			checked( themify_get( 'setting-exclude_header_widgets' ), 'on', false ),
			__('Exclude Header Widgets.', 'themify')
		);

		/**
		 * Exclude Social Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_social_widget',
			checked( themify_get( 'setting-exclude_social_widget' ), 'on', false ),
			__('Exclude Social Widgets.', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_menu_navigation',
			checked( themify_get( 'setting-exclude_menu_navigation' ), 'on', false ),
			__('Exclude Menu Navigation.', 'themify')
		);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	/**
	 * Header Widgets
	 */
	$options = array(
		array(
			'value' => 'headerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'headerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'headerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'headerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
		array(
			'value' => 'none',
			'img' => 'themify/img/sidebars/none.png',
			'title' => __('No Widgets', 'themify'))
	);
	$val = themify_get( 'setting-header_widgets' );

	$html .= '<p>
				<span class="label">' . __( 'Header Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$html .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-header_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';

	/**
	 * Footer Design
	 * @var array
	 */
	$design_options = themify_theme_footer_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$key = 'setting-footer_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none">';

		/**
		 * Footer Design
		 */
		$html .= '<p>
						<span class="label">' . __( 'Footer Design', 'themify' ) . '</span>';
		$val = themify_check( $key ) ? themify_get( $key ) : '';
		foreach ( $design_options as $option ) {
                        if($option['value']==='default'){
                            continue;
                        }
                        elseif($option['value']==='footer-block'){
                            $option['selected'] = true;
                        }
			if ( ( '' == $val || ! $val ) && $option['selected'] ) {
				$val = $option['value'];
			}

			$class = ( $val == $option['value'] ) ? 'selected' : '';

			$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . esc_attr( $key ) . '" class="val" value="' . esc_attr( $val ) . '" />
					</p>';

		// Exclusions

		$key = 'setting-exclude_';

		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_site_logo',
			checked( themify_get( $key . 'footer_site_logo' ), 'on', false ),
			__('Exclude Site Logo.', 'themify')
		);

		/**
		 * Exclude Footer Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_widgets',
			checked( themify_get( $key . 'footer_widgets' ), 'on', false ),
			__('Exclude Footer Widgets.', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_menu_navigation',
			checked( themify_get( $key . 'footer_menu_navigation' ), 'on', false ),
			__('Exclude Menu Navigation.', 'themify')
		);

		/**
		 * Exclude Footer Texts
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_texts',
			checked( themify_get( $key . 'footer_texts' ), 'on', false ),
			__('Exclude Footer Text', 'themify')
		);

		/**
		 * Exclude Footer Back to Top
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_back',
			checked( themify_get( $key . 'footer_back' ), 'on', false ),
			__('Exclude Back to Top button', 'themify')
		);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	$options = array(
		array(
			'value' => 'footerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'footerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'footerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'footerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
		array(
			'value' => 'none',
			'img' => 'themify/img/sidebars/none.png',
			'title' => __('No Widgets', 'themify'))
	);
	$val = themify_get( 'setting-footer_widgets' );
		
	$html .= '<p><span class="label">' . __( 'Footer Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$html .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-footer_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';
		
		// Footer widget position
		$key = 'setting-footer_widget_position';
	$html .= '<p><span class="label">' . __( 'Footer Widgets Position', 'themify' ) . '</span>';
		$html.='<select name="' . $key . '">' . themify_options_module( array(
				array( 'name' => __( 'After Footer Text', 'themify' ), 'value' => '' ),
				array( 'name' => __( 'Before Footer Text', 'themify' ), 'value' => 'top' ),
		), $key ) . '
		</select>';
		
	return $html;
}

/**
 * Markup for several color pickers module
 * @param array $data
 * @return string
 */
function themify_color_pickers_module( $data = array() ) {
	/**
	 * Variable key in theme settings
	 * @var string
	 */
	$key = '';

	/**
	 * Module markup
	 * @var string
	 */
	$html = '';
	$html .= '<div class="themify-info-link">'. __( 'The animating background colors can be enabled in header and footer. You can also insert in Builder row by adding "animated-bg" in Builder Row &gt; Options &gt; Additional CSS Class.', 'themify' ) .'</div>';

	// Color animation control for header
	$key = 'setting-header_color_animation_enabled';
	$html .= sprintf('<p><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key,
		checked( themify_get( $key ), 'on', false ),
		__( 'Enable animated colors in header.', 'themify' )
	);

	// Color animation control for footer
	$key = 'setting-footer_color_animation_enabled';
	$html .= sprintf('<p><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key,
		checked( themify_get( $key ), 'on', false ),
		__( 'Enable animated colors in footer.', 'themify' )
	);

	// Color animation speed
	$key = 'setting-color_animation_speed';
	$speed = themify_check( $key ) ? themify_get( $key ) : '5';
	$html .= '
		<div class="themify_field_row">
			<span class="label">' . __( 'Animation Speed', 'themify' ) . '</span>
			<input type="text" class="width2" name="' . $key . '" value="' . $speed . '" />
			<br/>
			<span class="pushlabel"><small>' . __( 'Enter the speed in seconds (example: 5)', 'themify' ) . '</small></span>
		</div>';

	// Create color pickers
	$key = 'setting-color_stop_';
	for ( $i = 1; $i <= 7; $i++ ) {
		$html .= '
		<div class="themify_field_row">
			<span class="label">' . sprintf( __( 'Color Animation #%s', 'themify' ), $i ) . '</span>
			<div class="themify_field-color"><span class="colorSelect"></span>
				<input type="text" id="' . $key . $i . '" name="' . $key . $i . '" value="' . themify_get( $key . $i ) . '" class="themify_input_field colorSelectInput" />
				<input type="button" class="button clearColor" value="' . __('&times;', 'themify') . '">
			</div>
		</div>';
	}

	return $html;
}

/**
 * Image Filter Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_image_filter( $data = array() ) {
	$data = themify_get_data();
	/**
	 * Theme Settings Option Key Prefix
	 *
	 * @var string
	 */
	$key = 'setting-imagefilter_options';

	/**
	 * Module markup
	 * @var string
	 */
	$out = '<p>
				<span class="label">' . __( 'Image Filter', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key ) . '
				</select>
			</p>';


	$out .= '<p>
				<span class="label">' . __( 'Image Hover Filter', 'themify' ) . '</span>
				<select name="' . $key . '_hover">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key . '_hover' ) . '
				</select>
			</p>';

	$key1 = 'setting-imagefilter_applyto';
	$preset = themify_check( $key1 ) ? themify_get( $key1 ) : 'featuredonly';
	$out .= '<p>
				<span class="label">' . __( 'Apply to', 'themify' ) . '</span>' .
		        sprintf('<label for="%1$s"><input type="radio" id="%1$s" name="%1$s" %2$s value="featuredonly" /> %3$s</label>',
				$key1, checked( $preset, 'featuredonly', false ), __( 'Featured Images Only', 'themify' ) ) .
				'<br/>
				<span class="pushlabel">' .
		        sprintf('<label for="%1$s"><input type="radio" id="%1$s" name="%1$s" %2$s value="allimages" /> %3$s</label>',
				$key1, checked( themify_get( $key1 ), 'allimages', false ), __( 'All Images', 'themify' ) ) . '
				</span>
			</p>';

	return $out;
}

/**
 * Markup for related posts module
 * @param array $data
 * @return string
 */
function themify_related_posts( $data = array() ) {

	/**
	 * Variable key in theme settings
	 * @var string
	 */
	$key = 'setting-relationship_taxonomy';

	$options = array(
		array( 'value' => 'category', 'name' => __( 'Category', 'themify' ) ),
		array( 'value' => 'tag', 'name' => __( 'Tags', 'themify' ) ),
		array( 'value' => 'none', 'name' => __( 'None', 'themify' ) ),
	);

	/**
	 * Post content display options
	 * @var array
	 */
	$display_content_options = array(
		array( 'name' => __( 'Full Content', 'themify' ), 'value' => 'content' ),
		array( 'name' => __( 'Excerpt', 'themify' ), 'value' => 'excerpt' ),
		array( 'name' => __( 'None', 'themify' ), 'value' => 'none',  )
	);

	$number = themify_check( $key.'_entries' ) ? themify_get( $key . '_entries' ) : 3;

	/**
	 * Module markup
	 * @var string
	 */
	$html = '';

	/**
	 * Taxonomy to use
	 */
	$html .= '<p>
				<span class="label">' . __( 'Relate Entries By', 'themify' ) . '</span>
				<select name="' . esc_attr( $key ) . '">' . themify_options_module( $options, $key . '' ) . '
				</select>
			</p>';

	/**
	 * Number of Entries
	 */
	$html .= '<p>
				<span class="label">' . __( 'Number of Entries', 'themify' ) . '</span>
				<input type="text" name="' . esc_attr( $key ) . '_entries" value="' . esc_attr( $number ) . '">
			</p>';

	/**
	 * Hide Image
	 */
	$html .= sprintf('<p><span class="pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></span></p>',
		esc_attr( $key . '_hide_image' ),
		checked( themify_get( $key . '_hide_image' ), 'on', false ),
		__('Hide Image.', 'themify')
	);

	/**
	 * Display Content
	 */
	$html .= '<p>
					<span class="label">' . __( 'Display Content', 'themify' ) . '</span> 
					<select name="' . esc_attr( $key . '_display_content' ) . '">' .
						themify_options_module( $display_content_options, $key . '_display_content', true, 'none' ) . '
					</select>
				</p>';

	return $html;
}

/**
 * Default Index Layout Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_default_layout( $data = array() ){
	$data = themify_get_data();

	/**
	 * Theme Settings Option Key Prefix
	 * @var string
	 */
	$prefix = 'setting-default_';
	
	if ( ! isset( $data[$prefix . 'more_text'] ) || '' == $data[$prefix . 'more_text'] ) {
		$more_text = __( 'More', 'themify' );
	} else {
		$more_text = $data[$prefix . 'more_text'];
	}

	/**
	 * Tertiary options <blank>|yes|no
	 * @var array
	 */
	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Yes', 'themify'), 'value' => 'yes'),
		array('name' => __('No', 'themify'), 'value' => 'no')
	);

	/**
	 * Default options 'yes', 'no'
	 * @var array
	 */
	$binary_options = array(
		array('name'=>__('Yes', 'themify'),'value'=>'yes'),
		array('name'=>__('No', 'themify'),'value'=>'no')
	);

	/**
	 * Post content display options
	 * @var array
	 */
	$default_display_options = array(
		array('name' => __('Full Content', 'themify'),'value' => 'content'),
		array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
		array('name' => __('None', 'themify'),'value' => 'none')
	);

	/**
	 * Post layout options
	 * @var array
	 */
	$default_post_layout_options = array(
		array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __( 'List Post', 'themify' ), "selected" => true),
		array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __( 'Grid 4', 'themify' )),
		array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __( 'Grid 3', 'themify' )),
		array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __( 'Grid 2', 'themify' )),
		array('value' => 'slider', 'img' => 'images/layout-icons/slider-default.png', 'title' => __( 'Slider', 'themify' )),
	);

	/**
	 * Sidebar placement options
	 * @var array
	 */
	$sidebar_location_options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify'))
	);

	/**
	 * Image alignment options
	 * @var array
	 */
	$alignment_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Left', 'themify'), 'value' => 'left'),
		array('name' => __('Right', 'themify'), 'value' => 'right')
	);

	/**
	 * Entry media position, above or below the title
	 */
	$media_position = array(
		array('name'=>__('Above Post Title', 'themify'), 'value'=>'above'),
		array('name'=>__('Below Post Title', 'themify'), 'value'=>'below'),
	);

	/**
	 * HTML for settings panel
	 * @var string
	 */
	$output = '<div class="themify-info-link">' . __( 'Here you can set the <a href="https://themify.me/docs/default-layouts">Default Layouts</a> for WordPress archive post layout (category, search, archive, tag pages, etc.), single post layout (single post page), and the static Page layout. The default single post and page layout can be override individually on the post/page &gt; edit &gt; Themify Custom Panel.', 'themify' ) . '</div>';
	
	/**
	 * Index Sidebar Option
	 */
	$output .= '<p>
					<span class="label">' . __('Archive Sidebar Option', 'themify') . '</span>';
	$val = isset( $data[$prefix.'layout'] ) ? $data[$prefix.'layout'] : '';
	foreach($sidebar_location_options as $option){
		if(($val == '' || !$val || !isset($val)) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';	
	}
	
	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Post Layout
	 */
	$output .= '<p>
					<span class="label">' . __('Post Layout', 'themify') . '</span>';
	$val = isset( $data[$prefix.'post_layout'] ) ? $data[$prefix.'post_layout'] : '';
	foreach($default_post_layout_options as $option){
		if(($val == '' || !$val || !isset($val)) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';	
	}

	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Post Content Layout
	 */
	$output .= '<p>
					<span class="label">' . __( 'Post Content Layout', 'themify' ) . '</span>
					<select name="setting-post_content_layout">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => '' ),
							array( 'name' => __( 'Overlay', 'themify' ), 'value' => 'overlay' ),
							array( 'name' => __( 'Polaroid', 'themify' ), 'value' => 'polaroid' )
						), 'setting-post_content_layout' ) . '
					</select>
				</p>';

	/**
	 * Enable Masonry
	 */
	$output .=	'<p>
					<span class="label">' . __('Post Masonry', 'themify') . '</span>
					<select name="setting-disable_masonry">' .
						themify_options_module($binary_options, 'setting-disable_masonry') . '
					</select>
				</p>';

	/**
	 * Post Gutter
	 */
	$output .= '<p>
					<span class="label">' . __( 'Post Gutter', 'themify' ) . '</span>
					<select name="setting-post_gutter">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => 'gutter' ),
							array( 'name' => __( 'No gutter', 'themify' ), 'value' => 'no-gutter' )
						), 'setting-post_gutter' ) . '
					</select>
				</p>';

	/**
	 * Display Content
	 */
	$output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="' . esc_attr( $prefix ) . 'layout_display">'.
						themify_options_module($default_display_options, $prefix.'layout_display').'
					</select>
				</p>';
	
	/**
	 * More Text
	 */
	$output .= '<p>
					<span class="label">' . __('More Text', 'themify') . '</span>
					<input type="text" name="' . esc_attr( $prefix ) . 'more_text" value="' . esc_attr( $more_text ) . '">
					
					<span class="pushlabel vertical-grouped"><label for="setting-excerpt_more"><input type="checkbox" value="1" id="setting-excerpt_more" name="setting-excerpt_more" '.checked( themify_get( 'setting-excerpt_more' ), 1, false ).'/> ' . __('Display more link button in excerpt mode as well.', 'themify') . '</label></span>
				</p>';

	/**
	 * Order & OrderBy Options
	 */
	$output .= themify_post_sorting_options('setting-index_order', $data);
				
	/**
	 * Hide Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_title">' .
						themify_options_module($default_options, $prefix.'post_title') . '
					</select>
				</p>';
	
	/**
	 * Unlink Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_title">' .
						themify_options_module($default_options, $prefix.'unlink_post_title') . '
					</select>
				</p>';
	
	/**
	 * Hide Post Meta
	 */
	$output .= themify_post_meta_options($prefix.'post_meta', $data);
	
	/**
	 * Hide Post Date
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Date', 'themify') . '</span>
					<select onchange="jQuery(this).val()===\'yes\'?jQuery(\'#'.$prefix.'display_date_inline_wrap\').fadeOut():jQuery(\'#'.$prefix.'display_date_inline_wrap\').fadeIn();" name="' . esc_attr( $prefix ) . 'post_date">' .
						themify_options_module($default_options, $prefix.'post_date') . '
					</select>
					<br/><br/>
					<span id="'.$prefix.'display_date_inline_wrap" class="pushlabel">
					   <label for="'.$prefix.'display_date_inline"><input type="checkbox" value="1" id="'.$prefix.'display_date_inline" name="'.$prefix.'display_date_inline" ' . checked( themify_get( $prefix.'display_date_inline' ), 1, false ) . '/>'. __('Display post date as inline text instead of circle style', 'themify') .'
					</span>
				</p>';
	
	/**
	 * Auto Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="setting-auto_featured_image"><input type="checkbox" value="1" id="setting-auto_featured_image" name="setting-auto_featured_image" ' . checked( themify_get( 'setting-auto_featured_image' ), 1, false ) . '/> ' . __( 'If no featured image is specified, display first image in content.', 'themify' ) . '</label>
				</p>';
	
	/**
	 * Featured Image/Media Position
	 */
	$output .= '<p>
					<span class="label">' . __( 'Featured Image/Media Position', 'themify' ) . '</span>
					<select name="' . esc_attr( $prefix ) . 'media_position">' .
						themify_options_module( $media_position, $prefix.'media_position' ) . '
					</select>
				</p>';
	
	/**
	 * Hide Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_image">' .
						themify_options_module($default_options, $prefix.'post_image') . '
					</select>
				</p>';
	
	/**
	 * Unlink Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_image">' .
						themify_options_module($default_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';
	
	/**
	 * Featured Image Sizes
	 */
	$output .= themify_feature_image_sizes_select('image_post_feature_size');
	
	/**
	 * Image Dimensions
	 */	
	$output .= '<p>
					<span class="label">' . __('Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="setting-image_post_width" value="' . themify_get( 'setting-image_post_width' ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2 show_if_enabled_img_php" name="setting-image_post_height" value="' . themify_get( 'setting-image_post_height' ) . '" /> <span class="show_if_enabled_img_php">' . __('height', 'themify') . ' <small>(px)</small></span>
					<br /><span class="pushlabel show_if_enabled_img_php"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';
	
	return $output;
}


if (!function_exists('themify_pagination_infinite')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_pagination_infinite($data = array()) {

		$output = '<p><span class="label">' . __( 'Pagination Option', 'themify' ) . '</span>';

		//Infinite Scroll
		$output .= '<input ' . checked( themify_check( 'setting-more_posts' ) ? themify_get( 'setting-more_posts' ) : 'infinite', 'infinite', false ) . ' type="radio" name="setting-more_posts" value="infinite" /> ';
		$output .= __('Infinite Scroll (posts are loaded on the same page)', 'themify');
		$output .= '<br/>';
		$output .= '<label for="setting-autoinfinite"><input class="disable-autoinfinite" type="checkbox" id="setting-autoinfinite" name="setting-autoinfinite" '.checked( themify_check( 'setting-autoinfinite' ), true, false ).'/> ' . __('Disable automatic infinite scroll', 'themify').'</label>';
		$output .= '<br/><br/>';

		//Numbered pagination
		$output .= '<span class="pushlabel"><input ' . checked( themify_get( 'setting-more_posts' ), 'pagination', false ) . ' type="radio" name="setting-more_posts" value="pagination" /> ';
		$output .= __('Standard Pagination', 'themify') . '</span>';
		$output .= '</p>';
		
		return $output;
	
	}

}


/**
 * Control page loader effect in regular pages.
 * @param array $data
 * @return string
 */
function themify_page_loader_effect( $data = array() ) {
	
	$key = 'setting-page_loader_color';
	$value = themify_get($key);
	$html='<div class="themify-info-link">'.__("This is the loading screen customization for 'section-scroll' layout (it will be in effect when the 'section-scroll' header design is selected)",'themify').'</div><p class="page_loader_wrap">
				<label class="label" for="'.$key.'">' . __('Loading screen color', 'themify') . '  </label>
				<span class="colorSelect" style=""><span></span></span> <input id="'.$key.'" type="text"  name="'.$key.'" class="colorSelectInput width4" value="'.esc_attr($value).'"/>
			</p>';
	$key = 'setting-page_loader_icon';
	$value = themify_get($key);
	$html.='<div class="themify_field_row page_loader_wrap">
					<span class="label">'. __('Loader Icon', 'themify') . '</span>
					<input id="'.$key.'" type="text" class="width10" name="'.$key.'" value="' . esc_attr( $value ) . '" /> <br />
					<span class="pushlabel">
						<a class="left button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#'.$key.'">'.__( 'Insert Icon', 'themify' ).'</a>
						<span style="margin: 2px 7px;font-size: 1.15em;" class="left">'.__('or', 'themify').'</span>
						<div class="left" style="margin-top: -4px;">' . themify_get_uploader($key, array('tomedia' => true,'label'=>__('Upload an image','themify'))) . '</div>
					</span>
			</div>';

	return $html;
}

/**
 * Settings for the slider in single post pages
 *
 * @since 1.4.5
 */
function single_post_slider_settings() {
	$output = '<p>
				<span class="label">' . __( 'Autoplay', 'themify' ) . '</span>
				<select name="setting-single_slider_autoplay">'.
					themify_options_module( array(
						array( 'name' => __( 'Off', 'themify' ), 'value' => 'off' ),
						array( 'name' => __( '1 Second', 'themify' ), 'value' => '1' ),
						array( 'name' => __( '2 Seconds', 'themify' ), 'value' => '2' ),
						array( 'name' => __( '3 Seconds', 'themify' ), 'value' => '3' ),
						array( 'name' => __( '4 Seconds', 'themify' ), 'value' => '4' ),
						array( 'name' => __( '5 Seconds', 'themify' ), 'value' => '5' ),
						array( 'name' => __( '6 Seconds', 'themify' ), 'value' => '6' ),
						array( 'name' => __( '7 Seconds', 'themify' ), 'value' => '7' ),
						array( 'name' => __( '8 Seconds', 'themify' ), 'value' => '8' ),
						array( 'name' => __( '9 Seconds', 'themify' ), 'value' => '9' ),
						array( 'name' => __( '10 Seconds', 'themify' ), 'value' => '10' ),
					), 'setting-single_slider_autoplay' ) . '
				</select>
			</p>';
	$output .= '<p>
				<span class="label">' . __( 'Transition Speed', 'themify' ) . '</span>
				<select name="setting-single_slider_speed">'.
					themify_options_module( array(
						array( 'name' => __( 'normal', 'themify' ), 'value' => 'normal' ),
						array( 'name' => __( 'Slow', 'themify' ), 'value' => 'slow' ),
						array( 'name' => __( 'Fast', 'themify' ), 'value' => 'fast' ),
					), 'setting-single_slider_speed' ) . '
				</select>
			</p>';
	$output .= '<p>
				<span class="label">' . __( 'Effect', 'themify' ) . '</span>
				<select name="setting-single_slider_effect">'.
					themify_options_module( array(
						array( 'name' => __( 'Slide', 'themify' ), 'value' => 'slide' ),
						array( 'name' => __( 'Fade', 'themify' ), 'value' => 'fade' ),
						array( 'name' => __( 'Crossfade', 'themify' ), 'value' => 'crossfade' ),
						array( 'name' => __( 'Cover', 'themify' ), 'value' => 'cover' ),
						array( 'name' => __( 'Cover Fade', 'themify' ), 'value' => 'cover-fade' ),
						array( 'name' => __( 'Uncover', 'themify' ), 'value' => 'uncover' ),
						array( 'name' => __( 'Uncover Fade', 'themify' ), 'value' => 'uncover-fade' ),
						array( 'name' => __( 'Continuously', 'themify' ), 'value' => 'continuously' ),
					), 'setting-single_slider_effect' ) . '
				</select>
			</p>';
	$output .= '<p>
				<span class="label">' . __( 'Slider Height', 'themify' ) . '</span>
				<select name="setting-single_slider_height">'.
					themify_options_module( array(
						array( 'name' => __( 'Auto', 'themify' ), 'value' => 'auto' ),
						array( 'name' => __( 'Variable', 'themify' ), 'value' => 'variable' ),
					), 'setting-single_slider_height' ) . '
				</select>
				<span class="description">'. __( '"Auto" measures the highest slide and all other slides will be set to that size. "Variable" makes every slide has it\'s own height', 'themify' ) . '</span>
			</p>';

	return $output;
}